/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.tagregistry;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.IComponentTagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.IConverterTagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagAttribute;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.IValidatorTagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.Namespace;
import org.eclipse.jst.jsf.common.ui.JSFUICommonPlugin;
import org.eclipse.jst.jsf.common.ui.internal.form.AbstractMasterForm;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.designtime.internal.view.model.ITagRegistry;
import org.eclipse.jst.jsf.ui.internal.JSFUITraceOptions;
import org.eclipse.jst.jsf.ui.internal.tagregistry.GenerateMetadataAction;
import org.eclipse.jst.jsf.ui.internal.tagregistry.Messages;
import org.eclipse.jst.jsf.ui.internal.tagregistry.ProjectTracker;
import org.eclipse.jst.jsf.ui.internal.tagregistry.SetInputRunnable;
import org.eclipse.jst.jsf.ui.internal.tagregistry.TaglibContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchViewerComparator;

public class TagRegistryMasterForm
extends AbstractMasterForm {
    private static final String REFRESH_NAV_IMAGE_FILE = "refresh_nav_16.gif";
    private TreeViewer _registryTreeViewer;
    private Action _refreshAction;
    private final ProjectTracker _projectTracker;
    private final ProjectTracker.ProjectAdvisor _advisor = new ProjectTracker.ProjectAdvisor(){

        public boolean shouldTrack(IProject project) {
            JSFVersion guessJSFVersion = JSFVersion.guessJSFVersion((IProject)project);
            return guessJSFVersion != null;
        }
    };
    private GenerateMetadataAction _generateMetadataAction;

    public TagRegistryMasterForm(FormToolkit toolkit) {
        super(toolkit);
        this._projectTracker = new ProjectTracker(ResourcesPlugin.getWorkspace().getRoot(), this._advisor);
    }

    public Control createClientArea(Composite parent) {
        Tree tree = this.getToolkit().createTree(parent, 772);
        GridData gridData = new GridData(4, 0x1000000, true, true);
        tree.setLayoutData((Object)gridData);
        this._registryTreeViewer = new TreeViewer(tree);
        this._registryTreeViewer.setContentProvider((IContentProvider)new TaglibContentProvider());
        this._registryTreeViewer.setLabelProvider((IBaseLabelProvider)new CommonLabelProvider());
        this._registryTreeViewer.setSorter((ViewerSorter)new NameSorter());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this._registryTreeViewer.getControl(), "ViewHandlerPrototype.viewer");
        this._projectTracker.addListener(new ProjectTracker.ProjectTrackingListener(){

            protected void projectsChanged(IProject project, ProjectTracker.ProjectTrackingListener.Reason reason) {
                switch (reason) {
                    case ADDED: 
                    case REMOVED: {
                        if (!project.equals(TagRegistryMasterForm.this._registryTreeViewer.getInput())) break;
                        TagRegistryMasterForm.this.updateProjects();
                    }
                }
            }
        });
        this._registryTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TagRegistryMasterForm.this.getListener().selectionChanged(event);
                TagRegistryMasterForm.this.updateActions(event.getSelection());
            }
        });
        this.makeActions();
        this.createContextMenuManager(this._registryTreeViewer.getControl());
        return tree;
    }

    public void dispose() {
        this._projectTracker.dispose();
    }

    private void updateProjects() {
        Set<IProject> projects = this._projectTracker.getProjects();
        Iterator<IProject> iterator = projects.iterator();
        if (iterator.hasNext()) {
            IProject project = iterator.next();
            new SetInputRunnable(project, (Viewer)this._registryTreeViewer).run();
        }
    }

    protected final void contributeActions(IToolBarManager formManager, IToolBarManager localManager) {
        localManager.add((IAction)this._refreshAction);
        localManager.update(false);
    }

    protected void contributeToHeadArea(FormToolkit toolkit, Composite container) {
        Label label = new Label(container, 0);
        label.setText(Messages.TagRegistryMasterForm_Project);
        final ComboViewer combo = new ComboViewer(container, 0x800008);
        this.getToolkit().adapt(combo.getControl(), true, false);
        combo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                IProject selectedProject = (IProject)selection.getFirstElement();
                TagRegistryMasterForm.this._registryTreeViewer.setInput((Object)selectedProject);
            }
        });
        combo.setLabelProvider((IBaseLabelProvider)new CommonLabelProvider());
        combo.setContentProvider((IContentProvider)new ProjectContentProvider());
        combo.setComparator((ViewerComparator)new WorkbenchViewerComparator());
        combo.setInput((Object)this._projectTracker);
        this._projectTracker.addListener(new ProjectTracker.ProjectTrackingListener(){

            protected void projectsChanged(IProject project, ProjectTracker.ProjectTrackingListener.Reason reason) {
                combo.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        combo.refresh();
                    }
                });
            }
        });
    }

    public void doInitialize() {
        this._projectTracker.startTracking();
    }

    private void makeActions() {
        if (this._registryTreeViewer == null) {
            throw new IllegalStateException("_registryTreeViewer must be initialized before calling makeActions");
        }
        this._refreshAction = new RefreshAction((StructuredViewer)this._registryTreeViewer);
        this._refreshAction.setText(Messages.TagRegistryMasterForm_RefreshRegistry);
        this._refreshAction.setToolTipText(Messages.TagRegistryMasterForm_RefreshRegistry);
        this._refreshAction.setImageDescriptor(JSFUICommonPlugin.getDefault().getImageDescriptor(REFRESH_NAV_IMAGE_FILE));
        if (JSFUITraceOptions.TRACE_METADATAGEN) {
            this._generateMetadataAction = new GenerateMetadataAction();
        }
    }

    private void createContextMenuManager(Control control) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                TagRegistryMasterForm.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
    }

    private void fillContextMenu(IMenuManager mgr) {
        if (JSFUITraceOptions.TRACE_METADATAGEN) {
            mgr.add((IAction)this._generateMetadataAction);
        }
    }

    private void updateActions(ISelection selection) {
        if (JSFUITraceOptions.TRACE_METADATAGEN) {
            this.updateMetadataGenAction(selection);
        }
    }

    private void updateMetadataGenAction(ISelection selection) {
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof Namespace) {
            Namespace ns = (Namespace)((IStructuredSelection)selection).getFirstElement();
            this._generateMetadataAction.setNamespace(ns);
            this._generateMetadataAction.setEnabled(true);
            return;
        }
        this._generateMetadataAction.setEnabled(false);
    }

    private static class CommonLabelProvider
    extends LabelProvider {
        private static final String CONFIGS_IMAGE_FILE = "configs.gif";

        private CommonLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof TaglibContentProvider.TagRegistryInstance) {
                return ((TaglibContentProvider.TagRegistryInstance)obj).getInfo().getDescription();
            }
            if (obj instanceof Namespace) {
                if (((Namespace)obj).getDisplayName() != null) {
                    return ((Namespace)obj).getDisplayName();
                }
                return ((Namespace)obj).getNSUri();
            }
            if (obj instanceof ITagElement) {
                return ((ITagElement)obj).getName();
            }
            if (obj instanceof ITagAttribute) {
                return ((ITagAttribute)obj).getName();
            }
            if (obj instanceof TaglibContentProvider.TreePlaceholder) {
                return ((TaglibContentProvider.TreePlaceholder)obj).getText();
            }
            if (obj instanceof IProject) {
                return ((IProject)obj).getName();
            }
            return obj.toString();
        }

        public Image getImage(Object obj) {
            if (obj instanceof Namespace) {
                return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.library_obj.gif");
            }
            if (obj instanceof TaglibContentProvider.TagRegistryInstance) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            if (obj instanceof ITagElement) {
                if (obj instanceof IComponentTagElement) {
                    return JSFUICommonPlugin.getDefault().getImage("object.gif");
                }
                if (obj instanceof IConverterTagElement) {
                    return JSFUICommonPlugin.getDefault().getImage("jsf_converter.gif");
                }
                if (obj instanceof IValidatorTagElement) {
                    return JSFUICommonPlugin.getDefault().getImage("jsf_validator.gif");
                }
                return JSFUICommonPlugin.getDefault().getImage("PD_Palette_Default.gif");
            }
            if (obj instanceof TaglibContentProvider.TreePlaceholder) {
                return JSFUICommonPlugin.getDefault().getImage(CONFIGS_IMAGE_FILE);
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    private static class ProjectContentProvider
    extends BaseWorkbenchContentProvider {
        private ProjectContentProvider() {
        }

        protected IWorkbenchAdapter getAdapter(Object element) {
            return new WorkbenchAdapter(){

                public Object[] getChildren(Object object) {
                    if (object instanceof ProjectTracker) {
                        return ((ProjectTracker)object).getProjects().toArray();
                    }
                    return new Object[0];
                }
            };
        }
    }

    private static class RefreshAction
    extends Action {
        private final StructuredViewer _viewer;

        private RefreshAction(StructuredViewer viewer) {
            this._viewer = viewer;
            this.setEnabled(false);
            this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    boolean enabled = false;
                    Object selectedObj = RefreshAction.this.getSelected(event.getSelection());
                    if (selectedObj instanceof TaglibContentProvider.TagRegistryInstance) {
                        enabled = true;
                    }
                    RefreshAction.this.setEnabled(enabled);
                }
            });
        }

        public void run() {
            TaglibContentProvider.TagRegistryInstance registryInstance;
            ITagRegistry registry;
            MessageDialog dialog = new MessageDialog(this._viewer.getControl().getShell(), Messages.TagRegistryMasterForm_FlushCacheQuestion, null, Messages.TagRegistryMasterForm_FlushCacheMessage, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
            boolean flushCaches = dialog.open() == 0;
            Object selectedObj = this.getSelected(this._viewer.getSelection());
            if (selectedObj instanceof TaglibContentProvider.TagRegistryInstance && (registry = (registryInstance = (TaglibContentProvider.TagRegistryInstance)selectedObj).getRegistry()) != null) {
                Runnable nullRunnable = new Runnable(){

                    public void run() {
                    }
                };
                registry.refresh(nullRunnable, flushCaches);
            }
        }

        private Object getSelected(ISelection selection) {
            IStructuredSelection structuredSel;
            if (selection instanceof IStructuredSelection && (structuredSel = (IStructuredSelection)selection).size() == 1) {
                return structuredSel.getFirstElement();
            }
            return null;
        }
    }
}

