/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.object;

import java.util.Vector;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class EJBTableViewer
extends TableViewer {
    private Vector beanNames;
    private Vector projectNames;

    public EJBTableViewer(Composite parent) {
        super(parent, 68356);
        String[] columnProperties = new String[]{ConsumptionUIMessages.TABLE_TITLE_EJB_BEAN_NAMES, ConsumptionUIMessages.TABLE_TITLE_EJB_PROJECT_NAME};
        int[] columnsWidth = new int[]{60, 20};
        int[] columnMins = new int[]{175, 125};
        Table table = this.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        int i = 0;
        while (i < columnProperties.length) {
            TableColumn column = new TableColumn(table, 0, i);
            column.setText(columnProperties[i]);
            column.pack();
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(columnsWidth[i], columnMins[i], true));
            ++i;
        }
        table.setLayout((Layout)layout);
        this.setColumnProperties(columnProperties);
        this.setContentProvider((IContentProvider)new EJBContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new EJBLabelProvider());
    }

    public void setData(Vector beanNames, Vector projectNames) {
        this.beanNames = beanNames;
        this.projectNames = projectNames;
    }

    public class EJBContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object element) {
            if (EJBTableViewer.this.beanNames != null) {
                int size = EJBTableViewer.this.beanNames.size();
                Object[] result = new Object[size];
                int index = 0;
                while (index < size) {
                    result[index] = new Integer(index);
                    ++index;
                }
                return result;
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object old, Object newobj) {
        }

        public boolean isDeleted(Object object) {
            return false;
        }
    }

    private class EJBLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private EJBLabelProvider() {
        }

        public String getColumnText(Object object, int columnIndex) {
            String result = null;
            if (object instanceof Integer) {
                int index = (Integer)object;
                if (columnIndex == 0) {
                    return (String)EJBTableViewer.this.beanNames.elementAt(index);
                }
                if (columnIndex == 1) {
                    return (String)EJBTableViewer.this.projectNames.elementAt(index);
                }
            }
            return result;
        }

        public Image getColumnImage(Object object, int columnIndex) {
            return null;
        }
    }
}

