/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.actions.managed.zoom;

import java.util.ArrayList;
import org.eclipse.gef.Disposable;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ZoomComboContributionItem;
import org.eclipse.jwt.we.editors.actions.handlers.ZoomInHandler;
import org.eclipse.jwt.we.editors.actions.handlers.ZoomOutHandler;
import org.eclipse.jwt.we.editors.pages.activityEditor.internal.IActivityEditor;
import org.eclipse.jwt.we.misc.util.GeneralHelper;

public class ZoomControl
implements ZoomListener,
Disposable {
    private static ZoomControl myinstance = null;
    private ZoomManager zoomManager;
    private ArrayList zoomInHandlers = new ArrayList();
    private ArrayList zoomOutHandlers = new ArrayList();
    private ZoomComboContributionItem zoomItem;

    private ZoomControl() {
    }

    public static ZoomControl getInstance() {
        if (myinstance == null) {
            myinstance = new ZoomControl();
        }
        return myinstance;
    }

    public void setZoomItem(ZoomComboContributionItem zoomItem) {
        this.zoomItem = zoomItem;
    }

    public void refreshZoomManager() {
        if (GeneralHelper.getActiveInstance() == null || !(GeneralHelper.getActiveInstance().getActiveEditor() instanceof IActivityEditor)) {
            if (this.zoomManager != null) {
                this.zoomManager.removeZoomListener((ZoomListener)this);
                this.zoomManager = null;
            }
            return;
        }
        ZoomManager newZoomManager = GeneralHelper.getActiveInstance().getCurrentActivitySheet().getRootEditPart().getZoomManager();
        if (newZoomManager == this.zoomManager) {
            return;
        }
        if (this.zoomManager != null) {
            this.zoomManager.removeZoomListener((ZoomListener)this);
        }
        this.zoomManager = newZoomManager;
        if (this.zoomManager != null) {
            this.zoomManager.addZoomListener((ZoomListener)this);
        }
    }

    private void refreshEnabledState(boolean enable) {
        if (enable && this.zoomManager != null && GeneralHelper.getActiveInstance() != null) {
            if (this.zoomItem != null) {
                this.zoomItem.setZoomManager(this.zoomManager);
            }
            boolean canZoomIn = this.zoomManager.canZoomIn();
            for (ZoomInHandler zih : this.zoomInHandlers) {
                zih.setEnabled(canZoomIn);
            }
            boolean canZoomOut = this.zoomManager.canZoomOut();
            for (ZoomOutHandler zoh : this.zoomOutHandlers) {
                zoh.setEnabled(canZoomOut);
            }
        } else {
            if (this.zoomItem != null) {
                this.zoomItem.setZoomManager(null);
            }
            for (ZoomInHandler zih : this.zoomInHandlers) {
                zih.setEnabled(false);
            }
            for (ZoomOutHandler zoh : this.zoomOutHandlers) {
                zoh.setEnabled(false);
            }
        }
    }

    public void enableZoom() {
        this.refreshEnabledState(true);
    }

    public void disableZoom() {
        this.refreshEnabledState(false);
    }

    public void zoomIn() {
        if (this.zoomManager != null) {
            this.zoomManager.zoomIn();
        }
    }

    public void zoomOut() {
        if (this.zoomManager != null) {
            this.zoomManager.zoomOut();
        }
    }

    public void zoomChanged(double zoom) {
        this.refreshEnabledState(true);
    }

    public void registerZoomInHandler(ZoomInHandler zoomInHandler) {
        this.zoomInHandlers.add(zoomInHandler);
        this.refreshEnabledState(true);
    }

    public void registerZoomOutHandler(ZoomOutHandler zoomOutHandler) {
        this.zoomOutHandlers.add(zoomOutHandler);
        this.refreshEnabledState(true);
    }

    public void unRegisterZoomInHandler(ZoomInHandler zoomInHandler) {
        this.zoomInHandlers.remove((Object)zoomInHandler);
    }

    public void unRegisterZoomOutHandler(ZoomOutHandler zoomOutHandler) {
        this.zoomOutHandlers.remove((Object)zoomOutHandler);
    }

    public void dispose() {
        if (this.zoomManager != null) {
            this.zoomManager.removeZoomListener((ZoomListener)this);
        }
        this.zoomManager = null;
        this.zoomItem = null;
    }
}

