/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.wizards.model;

import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jwt.meta.model.application.ApplicationFactory;
import org.eclipse.jwt.meta.model.core.CorePackage;
import org.eclipse.jwt.meta.model.core.Package;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.jwt.we.misc.wizards.model.SelectJarWizardPage;
import org.eclipse.jwt.we.misc.wizards.model.SelectNameWizardPage;
import org.eclipse.ui.IWorkbench;

public class CreateApplicationWizard
extends Wizard {
    protected SelectNameWizardPage initialPage;
    protected SelectJarWizardPage jarPage;
    protected Package defaultPackage = null;

    public CreateApplicationWizard() {
        this.setWindowTitle(PluginProperties.wizards_AppWizard_title);
    }

    public CreateApplicationWizard(Package defaultPackage) {
        this();
        this.defaultPackage = defaultPackage;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.initialPage = new SelectNameWizardPage(org.eclipse.jwt.meta.PluginProperties.model_Application_type, this.defaultPackage, workbench);
        this.jarPage = new SelectJarWizardPage(org.eclipse.jwt.meta.PluginProperties.model_Application_jarArchive_name);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.initialPage);
        this.initialPage.setDescription(PluginProperties.wizards_Page_name_package);
        this.addPage((IWizardPage)this.jarPage);
        this.jarPage.setDescription(PluginProperties.wizards_Page_jar);
    }

    public boolean performFinish() {
        String name = this.initialPage.getName();
        Package selectedPackage = this.initialPage.getPackage();
        String icon = this.initialPage.getIconPath();
        String jar = this.jarPage.getJar();
        String selclass = this.jarPage.getSelClass();
        String method = this.jarPage.getMethod();
        String webserviceInterface = this.jarPage.getInterface();
        String webserviceOperation = this.jarPage.getOperation();
        ApplicationFactory factory = ApplicationFactory.eINSTANCE;
        Object application = this.jarPage.getIsWebservice() ? factory.createWebServiceApplication() : factory.createApplication();
        application.setName(name);
        application.setIcon(icon);
        application.setJarArchive(jar);
        application.setJavaClass(selclass);
        application.setMethod(method);
        if (this.jarPage.getIsWebservice()) {
            application.setInterface(webserviceInterface);
            application.setOperation(webserviceOperation);
        }
        CommandParameter childDescriptor = new CommandParameter(null, (Object)CorePackage.Literals.PACKAGE__ELEMENTS, application);
        Command cmd = CreateChildCommand.create((EditingDomain)this.getEditingDomain(), (Object)selectedPackage, (Object)childDescriptor, Collections.singleton(selectedPackage));
        this.getEditingDomain().getCommandStack().execute(cmd);
        return true;
    }

    public EditingDomain getEditingDomain() {
        return (EditingDomain)GeneralHelper.getActiveInstance().getAdapter(EditingDomain.class);
    }
}

