/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.core.buildpath;

import java.util.Map;
import org.eclipse.core.runtime.IPath;

public class LuaExecutionEnvironment
implements Comparable<LuaExecutionEnvironment> {
    public static final String DEFAULT_TEMPLATE = "default";
    public static final String TEMPLATE_BUILDPATH = "buildpath";
    public static final Object OPEN_FILE = "openfile";
    private final String id;
    private final String version;
    private final IPath path;
    private final IPath oldTemplate;
    private final IPath templates;
    private final String luaGrammar;
    private boolean embedded;
    private Map<?, ?> templatesInfo;

    public LuaExecutionEnvironment(String identifier, String eeversion, Map<?, ?> templatesInfo, IPath pathToEE, String grammar) {
        this.id = identifier;
        this.version = eeversion;
        this.path = pathToEE;
        this.embedded = false;
        this.luaGrammar = grammar;
        this.templatesInfo = templatesInfo;
        IPath oldTemplatePath = null;
        if (pathToEE != null) {
            oldTemplatePath = pathToEE.append("template/");
        }
        this.oldTemplate = oldTemplatePath != null && oldTemplatePath.toFile().exists() ? oldTemplatePath : null;
        IPath templatesPath = null;
        if (pathToEE != null) {
            templatesPath = pathToEE.append("templates/");
        }
        this.templates = templatesPath != null && templatesPath.toFile().exists() ? templatesPath : null;
    }

    public void setEmbedded(boolean embeddedEE) {
        this.embedded = embeddedEE;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public String getID() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public IPath getPath() {
        return this.path;
    }

    public IPath[] getSourcepath() {
        IPath sourcePath;
        if (this.path != null && this.path.toFile().exists() && (sourcePath = this.path.append("api.zip")).toFile().exists()) {
            return new IPath[]{sourcePath};
        }
        return new IPath[0];
    }

    public IPath[] getDocumentationPath() {
        IPath sourcePath;
        if (this.path != null && this.path.toFile().exists() && (sourcePath = this.path.append("docs/")).toFile().exists()) {
            return new IPath[]{sourcePath};
        }
        return new IPath[0];
    }

    public String getEEIdentifier() {
        return String.valueOf(this.getID()) + '-' + this.getVersion();
    }

    public String toString() {
        return this.getEEIdentifier();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LuaExecutionEnvironment other = (LuaExecutionEnvironment)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    @Override
    public int compareTo(LuaExecutionEnvironment ee) {
        return this.getEEIdentifier().compareTo(ee.getEEIdentifier());
    }

    public IPath getOldTemplatePath() {
        return this.oldTemplate;
    }

    public IPath getTemplatesPath() {
        return this.templates;
    }

    public Map<?, ?> getDefaultTemplateInfo() {
        Object defaultTemplate;
        if (this.templatesInfo != null && (defaultTemplate = this.templatesInfo.get(DEFAULT_TEMPLATE)) instanceof Map && !((Map)defaultTemplate).isEmpty()) {
            return (Map)defaultTemplate;
        }
        return null;
    }

    public IPath getDefaultTemplatePath() {
        IPath templatesPath = this.getTemplatesPath();
        if (templatesPath == null) {
            return null;
        }
        return templatesPath.append(DEFAULT_TEMPLATE);
    }

    public String getLuaGrammar() {
        return this.luaGrammar;
    }
}

