/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.oprofile.ui.model;

import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelSample;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiMessages;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiPlugin;
import org.eclipse.linuxtools.oprofile.ui.model.IUiModelElement;
import org.eclipse.swt.graphics.Image;

public class UiModelSample
implements IUiModelElement {
    private IUiModelElement parent;
    private OpModelSample sample;
    private int totalCount;

    public UiModelSample(IUiModelElement parent, OpModelSample sample, int totalCount) {
        this.parent = parent;
        this.sample = sample;
        this.totalCount = totalCount;
    }

    public String toString() {
        double countPercentage = (double)this.sample.getCount() / (double)this.totalCount;
        String percentage = OprofileUiPlugin.getPercentageString(countPercentage);
        return String.valueOf(percentage) + " " + OprofileUiMessages.getString("uimodel.sample.on.line") + " " + Integer.toString(this.sample.getLine());
    }

    public int getLine() {
        return this.sample.getLine();
    }

    public String getFile() {
        return this.sample.getFilePath();
    }

    public double getCountPercentage() {
        return (double)this.sample.getCount() / (double)this.totalCount;
    }

    @Override
    public String getLabelText() {
        return this.toString();
    }

    @Override
    public IUiModelElement[] getChildren() {
        return null;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public IUiModelElement getParent() {
        return this.parent;
    }

    @Override
    public Image getLabelImage() {
        return OprofileUiPlugin.getImageDescriptor("icons/sample.gif").createImage();
    }
}

