/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactScanningListener;
import org.apache.maven.index.IndexerEngine;
import org.apache.maven.index.ScanningResult;
import org.apache.maven.index.artifact.IllegalArtifactCoordinateException;
import org.apache.maven.index.context.IndexingContext;
import org.codehaus.plexus.logging.AbstractLogEnabled;

class DefaultScannerListener
extends AbstractLogEnabled
implements ArtifactScanningListener {
    private final IndexingContext context;
    private final IndexerEngine indexerEngine;
    private final boolean update;
    private final ArtifactScanningListener listener;
    private final Set<String> uinfos = new HashSet<String>();
    private final Set<String> processedUinfos = new HashSet<String>();
    private final Set<String> allGroups = new HashSet<String>();
    private final Set<String> groups = new HashSet<String>();
    private final List<Exception> exceptions = new ArrayList<Exception>();
    private int count = 0;

    DefaultScannerListener(IndexingContext context, IndexerEngine indexerEngine, boolean update, ArtifactScanningListener listener) {
        this.context = context;
        this.indexerEngine = indexerEngine;
        this.update = update;
        this.listener = listener;
    }

    public void scanningStarted(IndexingContext ctx) {
        try {
            if (this.update) {
                this.initialize(ctx);
            }
        }
        catch (IOException ex) {
            this.exceptions.add(ex);
        }
        if (this.listener != null) {
            this.listener.scanningStarted(ctx);
        }
    }

    public void artifactDiscovered(ArtifactContext ac) {
        String uinfo = ac.getArtifactInfo().getUinfo();
        if (this.processedUinfos.contains(uinfo)) {
            return;
        }
        boolean adding = this.processedUinfos.add(uinfo);
        if (this.uinfos.contains(uinfo)) {
            this.uinfos.remove(uinfo);
            return;
        }
        try {
            if (this.listener != null) {
                this.listener.artifactDiscovered(ac);
            }
            this.indexerEngine.index(this.context, ac);
            for (Exception e : ac.getErrors()) {
                this.artifactError(ac, e);
            }
            this.groups.add(ac.getArtifactInfo().getRootGroup());
            this.allGroups.add(ac.getArtifactInfo().groupId);
            ++this.count;
        }
        catch (IOException ex) {
            this.artifactError(ac, ex);
        }
    }

    public void scanningFinished(IndexingContext ctx, ScanningResult result) {
        result.setTotalFiles(this.count);
        for (Exception ex : this.exceptions) {
            result.addException(ex);
        }
        try {
            this.context.optimize();
            this.context.setRootGroups(this.groups);
            this.context.setAllGroups(this.allGroups);
            if (this.update) {
                this.removeDeletedArtifacts(this.context, result);
            }
        }
        catch (IOException ex) {
            result.addException(ex);
        }
        if (this.listener != null) {
            this.listener.scanningFinished(ctx, result);
        }
        if (result.getDeletedFiles() > 0 || result.getTotalFiles() > 0) {
            try {
                this.context.updateTimestamp(true);
                this.context.optimize();
            }
            catch (Exception ex) {
                result.addException(ex);
            }
        }
    }

    public void artifactError(ArtifactContext ac, Exception e) {
        this.exceptions.add(e);
        if (this.listener != null) {
            this.listener.artifactError(ac, e);
        }
    }

    private void initialize(IndexingContext ctx) throws IOException, CorruptIndexException {
        IndexReader r = ctx.getIndexReader();
        for (int i = 0; i < r.maxDoc(); ++i) {
            Document d;
            String uinfo;
            if (r.isDeleted(i) || (uinfo = (d = r.document(i)).get(ArtifactInfo.UINFO)) == null) continue;
            this.uinfos.add(uinfo);
            String groupId = uinfo.substring(0, uinfo.indexOf(124));
            int n = groupId.indexOf(46);
            this.groups.add(n == -1 ? groupId : groupId.substring(0, n));
            this.allGroups.add(groupId);
        }
    }

    private void removeDeletedArtifacts(IndexingContext context, ScanningResult result) throws IOException {
        int deleted = 0;
        for (String uinfo : this.uinfos) {
            Term term = new Term(ArtifactInfo.UINFO, uinfo);
            Hits hits = context.getIndexSearcher().search((Query)new TermQuery(term));
            if (hits.length() <= 0) continue;
            String[] ra = ArtifactInfo.FS_PATTERN.split(uinfo);
            ArtifactInfo ai = new ArtifactInfo();
            ai.repository = context.getRepositoryId();
            ai.groupId = ra[0];
            ai.artifactId = ra[1];
            ai.version = ra[2];
            if (ra.length > 3) {
                ai.classifier = ArtifactInfo.renvl(ra[3]);
            }
            if (ra.length > 4) {
                ai.packaging = ArtifactInfo.renvl(ra[4]);
            }
            try {
                ArtifactContext ac = new ArtifactContext(null, null, null, ai, ai.calculateGav());
                for (int i = 0; i < hits.length(); ++i) {
                    this.indexerEngine.remove(context, ac);
                    ++deleted;
                }
            }
            catch (IllegalArtifactCoordinateException e) {
                this.getLogger().warn("Failed to remove deleted artifact from Search Engine.", (Throwable)e);
            }
        }
        result.setDeletedFiles(deleted);
    }
}

