/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.workbench.GradientDrawer;
import org.eclipse.mylyn.internal.tasks.core.Category;
import org.eclipse.mylyn.internal.tasks.core.ITaskRepositoryFilter;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.AddRepositoryAction;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoriesViewSorter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoryLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.wizards.Messages;
import org.eclipse.mylyn.internal.tasks.ui.wizards.MultiRepositoryAwareWizard;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.themes.IThemeManager;

public abstract class SelectRepositoryPage
extends WizardSelectionPage {
    private TreeViewer viewer;
    protected MultiRepositoryAwareWizard wizard;
    private List<TaskRepository> repositories = new ArrayList<TaskRepository>();
    private final ITaskRepositoryFilter taskRepositoryFilter;

    public SelectRepositoryPage(ITaskRepositoryFilter taskRepositoryFilter) {
        super(Messages.SelectRepositoryPage_Select_a_repository);
        this.setTitle(Messages.SelectRepositoryPage_Select_a_repository);
        this.setDescription(Messages.SelectRepositoryPage_Add_new_repositories_using_the_X_view);
        this.taskRepositoryFilter = taskRepositoryFilter;
        this.repositories = this.getTaskRepositories();
    }

    public List<TaskRepository> getTaskRepositories() {
        ArrayList<TaskRepository> repositories = new ArrayList<TaskRepository>();
        TaskRepositoryManager repositoryManager = TasksUiPlugin.getRepositoryManager();
        for (AbstractRepositoryConnector connector : repositoryManager.getRepositoryConnectors()) {
            Set connectorRepositories = repositoryManager.getRepositories(connector.getConnectorKind());
            for (TaskRepository repository : connectorRepositories) {
                if (!this.taskRepositoryFilter.accept(repository, connector)) continue;
                repositories.add(repository);
            }
        }
        return repositories;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        container.setLayout((Layout)layout);
        Tree tree = this.createTableViewer(container);
        this.viewer.setSorter((ViewerSorter)new TaskRepositoriesViewSorter());
        GridData gridData = new GridData(1808);
        tree.setLayoutData((Object)gridData);
        Composite buttonContainer = new Composite(container, 0);
        GridLayout buttonLayout = new GridLayout(2, false);
        buttonContainer.setLayout((Layout)buttonLayout);
        final AddRepositoryAction action = new AddRepositoryAction();
        action.setPromptToAddQuery(false);
        Button button = new Button(buttonContainer, 0);
        button.setLayoutData((Object)new GridData(34));
        button.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.REPOSITORY_NEW));
        button.setText(AddRepositoryAction.TITLE);
        button.setEnabled(action.isEnabled());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskRepository taskRepository = action.showWizard();
                if (taskRepository != null) {
                    SelectRepositoryPage.this.repositories = SelectRepositoryPage.this.getTaskRepositories();
                    SelectRepositoryPage.this.viewer.setInput((Object)TasksUi.getRepositoryManager().getRepositoryConnectors());
                    SelectRepositoryPage.this.viewer.setSelection((ISelection)new StructuredSelection((Object)taskRepository));
                }
            }
        });
        final Command discoveryWizardCommand = TasksUiInternal.getConfiguredDiscoveryWizardCommand();
        if (discoveryWizardCommand != null && discoveryWizardCommand.isEnabled()) {
            Button discoveryButton = new Button(buttonContainer, 8);
            GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)discoveryButton);
            discoveryButton.setText(Messages.SelectRepositoryConnectorPage_activateDiscovery);
            discoveryButton.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.DISCOVERY));
            discoveryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                    try {
                        handlerService.executeCommand(discoveryWizardCommand.getId(), null);
                    }
                    catch (Exception e) {
                        Status status = new Status(4, "org.eclipse.mylyn.tasks.ui", NLS.bind((String)Messages.SelectRepositoryConnectorPage_discoveryProblemMessage, (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                        TasksUiInternal.logAndDisplayStatus(Messages.SelectRepositoryConnectorPage_discoveryProblemTitle, (IStatus)status);
                    }
                }
            });
        }
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    protected Tree createTableViewer(Composite container) {
        this.viewer = new TreeViewer(container, 2820);
        this.viewer.setContentProvider((IContentProvider)new RepositoryContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new TaskRepositoryLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.viewer.setInput((Object)TasksUi.getRepositoryManager().getRepositoryConnectors());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.getFirstElement() instanceof TaskRepository) {
                    SelectRepositoryPage.this.setSelectedNode(new CustomWizardNode((TaskRepository)selection.getFirstElement()));
                    SelectRepositoryPage.this.setPageComplete(true);
                } else {
                    SelectRepositoryPage.this.setSelectedNode(null);
                    SelectRepositoryPage.this.setPageComplete(false);
                }
            }
        });
        TaskRepository selectedRepository = TasksUiUtil.getSelectedRepository(null);
        if (selectedRepository != null) {
            Category category = ((TaskRepositoryManager)TasksUi.getRepositoryManager()).getCategory(selectedRepository);
            Object[] path = new Object[]{category, selectedRepository};
            this.viewer.setSelection((ISelection)new TreeSelection(new TreePath(path)));
        } else {
            TaskRepository localRepository = TasksUi.getRepositoryManager().getRepository("local", "local");
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)localRepository));
        }
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        new GradientDrawer(themeManager, this.getViewer()){

            protected boolean shouldApplyGradient(Event event) {
                return event.item.getData() instanceof Category;
            }
        };
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (SelectRepositoryPage.this.canFlipToNextPage()) {
                    try {
                        SelectRepositoryPage.this.getContainer().showPage(SelectRepositoryPage.this.getNextPage());
                    }
                    catch (RuntimeException e) {
                        StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "Exception while opening the next wizard page", (Throwable)e));
                    }
                } else if (SelectRepositoryPage.this.canFinish() && SelectRepositoryPage.this.getWizard().performFinish()) {
                    ((WizardDialog)SelectRepositoryPage.this.getContainer()).close();
                }
            }
        });
        this.viewer.expandAll();
        this.viewer.getTree().showSelection();
        this.viewer.getTree().setFocus();
        return this.viewer.getTree();
    }

    protected abstract IWizard createWizard(TaskRepository var1);

    public boolean canFlipToNextPage() {
        return this.getSelectedNode() != null && this.getNextPage() != null;
    }

    public boolean canFinish() {
        return this.getSelectedNode() != null && this.getNextPage() == null;
    }

    public boolean performFinish() {
        if (this.getSelectedNode() == null || this.getNextPage() != null) {
            return false;
        }
        return this.getSelectedNode().getWizard().performFinish();
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public List<TaskRepository> getRepositories() {
        return this.repositories;
    }

    private class CustomWizardNode
    implements IWizardNode {
        private final TaskRepository repository;
        private IWizard wizard;

        public CustomWizardNode(TaskRepository repository) {
            this.repository = repository;
        }

        public void dispose() {
            if (this.wizard != null) {
                this.wizard.dispose();
            }
        }

        public Point getExtent() {
            return new Point(-1, -1);
        }

        public IWizard getWizard() {
            if (this.wizard == null) {
                this.wizard = SelectRepositoryPage.this.createWizard(this.repository);
                if (this.wizard != null) {
                    this.wizard.setContainer(SelectRepositoryPage.this.getContainer());
                }
            }
            return this.wizard;
        }

        public boolean isContentCreated() {
            return this.wizard != null;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CustomWizardNode)) {
                return false;
            }
            CustomWizardNode that = (CustomWizardNode)obj;
            if (this == that) {
                return true;
            }
            return this.repository.getConnectorKind().equals(that.repository.getConnectorKind()) && this.repository.getRepositoryUrl().equals(that.repository.getRepositoryUrl());
        }

        public int hashCode() {
            return 31 * this.repository.getRepositoryUrl().hashCode() + this.repository.getConnectorKind().hashCode();
        }
    }

    class RepositoryContentProvider
    implements ITreeContentProvider {
        RepositoryContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return SelectRepositoryPage.this.repositories.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

