/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pmf.ui.properties.validators;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.xwt.IValidationRule;
import org.eclipse.xwt.validation.AbstractValidationRule;

public class EmailValidator
extends AbstractValidationRule {
    private static final String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private Pattern pattern = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
    private Matcher matcher;

    public IValidationRule.Phase getPhase() {
        return IValidationRule.Phase.BeforeSet;
    }

    public IValidationRule.Direction getBindingMode() {
        return IValidationRule.Direction.TargetToSource;
    }

    public IStatus validate(Object value) {
        if (value == null || value.equals("")) {
            return ValidationStatus.error((String)"Email can not be empty.");
        }
        this.matcher = this.pattern.matcher(value.toString());
        if (this.matcher.matches()) {
            return ValidationStatus.ok();
        }
        return ValidationStatus.error((String)("'" + value.toString() + "' is not a validate email."));
    }

    public IStatus validateBack(Object value) {
        return this.validate(value);
    }
}

