/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.AbstractTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ConnectivityChecker;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.LoadingRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.UtilityAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.Concurrency;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.ConnectionManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.ScheduleAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.ConcurrentPartitionMerger;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.SequentialPartitionMerger;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.RootPartitionAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.utilities.StandardLibraryHelper;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeHelper;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Connection;
import org.eclipse.qvtd.pivot.qvtschedule.LoadingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.Partition;
import org.eclipse.qvtd.pivot.qvtschedule.QVTscheduleFactory;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.RootPartition;
import org.eclipse.qvtd.pivot.qvtschedule.RootRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.Graphable;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleConstants;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.SymbolNameBuilder;

public class QVTs2QVTs
extends QVTimperativeHelper {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull ProblemHandler problemHandler;
    protected final @NonNull String rootName;
    private final @NonNull LoadingRegionAnalysis loadingRegionAnalysis;
    protected final @NonNull CompleteModel completeModel;
    private final @NonNull Map<@NonNull Region, @NonNull RegionAnalysis> region2regionAnalysis = new HashMap<Region, RegionAnalysis>();
    private final @NonNull Map<@NonNull Model, DomainUsage> inputModels = new HashMap<Model, DomainUsage>();
    private final @NonNull StandardLibraryHelper standardLibraryHelper;

    public QVTs2QVTs(@NonNull ProblemHandler problemHandler, @NonNull ScheduleManager qvtm2qvts, @NonNull String rootName) {
        super(qvtm2qvts.getEnvironmentFactory());
        this.scheduleManager = qvtm2qvts;
        this.standardLibraryHelper = new StandardLibraryHelper(this.standardLibrary);
        this.problemHandler = problemHandler;
        this.rootName = rootName;
        this.loadingRegionAnalysis = new LoadingRegionAnalysis(this.scheduleManager, this.createLoadingRegion());
        this.completeModel = this.environmentFactory.getCompleteModel();
        this.scheduleManager.createConnectionManager(problemHandler, this.loadingRegionAnalysis);
    }

    private void computeInputModels() {
        for (ClassDatum classDatum : this.scheduleManager.getClassDatums()) {
            Model model;
            Class type;
            Package asPackage;
            DomainUsage domainUsage = this.scheduleManager.getDomainUsage((Element)classDatum);
            if (!domainUsage.isInput() || domainUsage.isOutput() || (asPackage = PivotUtil.getContainingPackage((EObject)(type = classDatum.getPrimaryClass()))) == null || "http://www.eclipse.org/ocl/2015/Orphanage".equals(asPackage.getURI()) || (model = PivotUtil.getContainingModel((EObject)type)) == null) continue;
            this.inputModels.put(model, domainUsage);
        }
        if (QVTm2QVTs.DUMP_INPUT_MODEL_TO_DOMAIN_USAGE.isActive()) {
            QVTm2QVTs.DUMP_INPUT_MODEL_TO_DOMAIN_USAGE.println(this.dumpInputModels().reduce("", QVTscheduleUtil.stringJoin((String)"\n\t")));
        }
    }

    private @NonNull LoadingRegion createRootContainmentRegion(@NonNull RootPartitionAnalysis rootPartitionAnalysis) {
        RootRegion rootRootRegion = rootPartitionAnalysis.getRootRegion();
        LoadingRegion loadingRegion = (LoadingRegion)this.loadingRegionAnalysis.getRegion();
        assert (rootRootRegion.getOwnedLoadingRegion() == loadingRegion);
        this.scheduleManager.writeDebugGraphs((Graphable)loadingRegion, null);
        return loadingRegion;
    }

    protected @NonNull LoadingRegion createLoadingRegion() {
        LoadingRegion loadingRegion = QVTscheduleFactory.eINSTANCE.createLoadingRegion();
        loadingRegion.setName(String.valueOf(this.rootName) + "-" + "\u00abload\u00bb");
        SymbolNameBuilder s = new SymbolNameBuilder();
        s.appendString("__load__");
        loadingRegion.setSymbolName(this.scheduleManager.getScheduleModel().reserveSymbolName(s, (Object)loadingRegion));
        return loadingRegion;
    }

    private Stream<String> dumpInputModels() {
        Stream<String> entries = this.inputModels.keySet().stream().map(k -> String.valueOf(String.valueOf(k)) + " : " + String.valueOf(this.inputModels.get(k)));
        return entries.sorted();
    }

    public @NonNull RegionAnalysis getRegionAnalysis(@NonNull Region region) {
        RegionAnalysis regionAnalysis = this.region2regionAnalysis.get(region);
        if (regionAnalysis == null) {
            regionAnalysis = this.scheduleManager.getRegionAnalysis(region);
            this.region2regionAnalysis.put(region, regionAnalysis);
        }
        return regionAnalysis;
    }

    public @NonNull ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    public @NonNull StandardLibraryHelper getStandardLibraryHelper() {
        return this.standardLibraryHelper;
    }

    protected @NonNull PartitionedTransformationAnalysis partition(ScheduleManager scheduleManager, @NonNull RootRegion rootRegion, @NonNull Iterable<? extends @NonNull Region> activeRegions) throws CompilerChainException {
        AbstractTransformationAnalysis transformationAnalysis = scheduleManager.getTransformationAnalysis(rootRegion);
        PartitionedTransformationAnalysis partitionedTransformationAnalysis = transformationAnalysis.partition(this.problemHandler, activeRegions);
        RootPartitionAnalysis rootPartitionAnalysis = partitionedTransformationAnalysis.getRootPartitionAnalysis();
        rootPartitionAnalysis.setRootRegion(rootRegion);
        return partitionedTransformationAnalysis;
    }

    protected void pruneRedundantConnections(@NonNull ConnectionManager connectionManager, @NonNull RootRegion rootRegion) {
        ArrayList<@NonNull Connection> redundantConnections = null;
        for (Connection connection : QVTscheduleUtil.getOwnedConnections((RootRegion)rootRegion)) {
            if (connection.isPassed() || connection.isMandatory()) continue;
            boolean isRedundant = true;
            int lastPass = connection.getLastPass();
            for (Partition targetPartition : connection.getTargetPartitions()) {
                int firstPass = targetPartition.getFirstPass();
                if (firstPass > lastPass) continue;
                isRedundant = false;
                break;
            }
            if (!isRedundant) continue;
            if (redundantConnections == null) {
                redundantConnections = new ArrayList<Connection>();
            }
            redundantConnections.add(connection);
        }
        if (redundantConnections != null) {
            for (Connection redundantConnection : redundantConnections) {
                redundantConnection.destroy();
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void schedule(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis) {
        List<Concurrency> partitionSchedule2;
        RootPartitionAnalysis rootPartitionAnalysis = partitionedTransformationAnalysis.getRootPartitionAnalysis();
        RootPartition rootPartition = (RootPartition)rootPartitionAnalysis.getPartition();
        RootRegion rootRegion = rootPartitionAnalysis.getRootRegion();
        ConnectionManager connectionManager = this.scheduleManager.getConnectionManager();
        @NonNull Iterable partitionSchedule = rootPartitionAnalysis.getPartitionSchedule();
        connectionManager.createConnections(rootRegion, partitionSchedule);
        ScheduleAnalysis scheduleAnalysis = new ScheduleAnalysis(partitionedTransformationAnalysis, connectionManager, rootPartitionAnalysis);
        scheduleAnalysis.schedule(rootPartition, (List<Concurrency>)partitionSchedule);
        List activeRegions = rootRegion.getActiveRegions();
        activeRegions.clear();
        List<@NonNull Concurrency> partitionSchedule1 = ConcurrentPartitionMerger.merge(partitionedTransformationAnalysis, (List<Concurrency>)rootPartitionAnalysis.getPartitionSchedule());
        List<@NonNull Concurrency> mergedPartitionSchedule = partitionSchedule2 = SequentialPartitionMerger.merge(partitionedTransformationAnalysis, partitionSchedule1);
        this.computeInputModels();
        this.createRootContainmentRegion(rootPartitionAnalysis);
        ArrayList<@NonNull RootPartition> allRootPartitions = new ArrayList<RootPartition>();
        allRootPartitions.add(rootPartition);
        this.pruneRedundantConnections(connectionManager, rootRegion);
        this.scheduleManager.writeDebugGraphs("8-pruned", true, true, false);
        ConnectivityChecker.CONNECTIVITY.isActive();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Iterable<@NonNull RootRegion> transform(@NonNull ScheduleManager scheduleManager, @NonNull Map<@NonNull RootRegion, Iterable<@NonNull MappingRegion>> rootRegion2activeRegions) throws CompilerChainException {
        ConnectionManager connectionManager = scheduleManager.getConnectionManager();
        LoadingRegion loadingRegion = (LoadingRegion)this.loadingRegionAnalysis.getRegion();
        Set<@NonNull RootRegion> rootRegions = rootRegion2activeRegions.keySet();
        ArrayList<@NonNull PartitionedTransformationAnalysis> partitionedTransformationAnalyses = new ArrayList<PartitionedTransformationAnalysis>();
        for (RootRegion rootRegion : rootRegions) {
            assert (rootRegion.getActiveRegions().isEmpty());
            Iterable<@NonNull MappingRegion> activeRegions = rootRegion2activeRegions.get(rootRegion);
            assert (activeRegions != null);
            ArrayList<@NonNull LoadingRegion> activeRegions2 = new ArrayList<LoadingRegion>();
            activeRegions2.add(loadingRegion);
            Iterables.addAll(activeRegions2, activeRegions);
            Collections.sort(activeRegions2, NameUtil.NAMEABLE_COMPARATOR);
            rootRegion.getActiveRegions().addAll(activeRegions2);
            StringBuilder s = QVTscheduleConstants.CONNECTION_CREATION.isActive() ? new StringBuilder() : null;
            for (Region region : activeRegions2) {
                if (region instanceof LoadingRegion) continue;
                connectionManager.createIncomingConnections(s, rootRegion, region);
            }
            if (s == null) continue;
            QVTscheduleConstants.CONNECTION_CREATION.println(s.toString());
        }
        UtilityAnalysis.assignUtilities(scheduleManager, (Region)loadingRegion);
        scheduleManager.writeDebugGraphs("4-pre-partition", true, true, false);
        scheduleManager.throwCompilerChainExceptionForErrors();
        for (RootRegion rootRegion : rootRegions) {
            @NonNull Iterable activeRegions2 = QVTscheduleUtil.getActiveRegions((RootRegion)rootRegion);
            PartitionedTransformationAnalysis partitionedTransformationAnalysis = this.partition(scheduleManager, rootRegion, activeRegions2);
            partitionedTransformationAnalyses.add(partitionedTransformationAnalysis);
            for (Region region : QVTscheduleUtil.getActiveRegions((RootRegion)rootRegion)) {
                connectionManager.createPartitionConnections(rootRegion, region);
            }
        }
        scheduleManager.writeDebugGraphs("5-post-partition", true, true, false);
        scheduleManager.throwCompilerChainExceptionForErrors();
        for (PartitionedTransformationAnalysis partitionedTransformationAnalysis : partitionedTransformationAnalyses) {
            this.schedule(partitionedTransformationAnalysis);
        }
        scheduleManager.writeDebugGraphs("9-final", true, true, false);
        return rootRegions;
    }
}

