/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.util;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.scout.sdk.core.util.SdkLog;

public final class StubUtilityBridge {
    private static Class<?> stubUtilityClass;

    private StubUtilityBridge() {
    }

    public static Template getCodeTemplate(String id, IJavaProject project) {
        try {
            return (Template)StubUtilityBridge.getStubUtilityClass().getMethod("getCodeTemplate", String.class, IJavaProject.class).invoke(null, id, project);
        }
        catch (Throwable e) {
            SdkLog.error((Object[])new Object[]{e});
            return null;
        }
    }

    private static Class<?> getStubUtilityClass() {
        Class<?> ret = stubUtilityClass;
        if (ret == null) {
            try {
                ret = StubUtilityBridge.class.getClassLoader().loadClass("org.eclipse.jdt.internal.core.manipulation.StubUtility");
            }
            catch (ClassNotFoundException e) {
                ret = StubUtilityBridge.loadLegacyStubUtilityClass();
            }
            stubUtilityClass = ret;
        }
        return ret;
    }

    private static Class<?> loadLegacyStubUtilityClass() {
        try {
            return StubUtilityBridge.class.getClassLoader().loadClass("org.eclipse.jdt.internal.corext.codemanipulation.StubUtility");
        }
        catch (ClassNotFoundException e1) {
            SdkLog.error((String)"Could not found a StubUtility class on classpath.", (Object[])new Object[0]);
            return null;
        }
    }
}

