/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberResourceMappingContext;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceTraversalAction;
import org.eclipse.team.internal.ccvs.ui.wizards.GenerateDiffFileWizard;
import org.eclipse.ui.PlatformUI;

public class GenerateDiffFileAction
extends WorkspaceTraversalAction {
    public void execute(IAction action) {
        try {
            IResource[][] resources = new IResource[1][];
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(monitor -> {
                try {
                    iResourceArray[0] = this.getDeepResourcesToPatch(monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            });
            GenerateDiffFileWizard.run(this.getTargetPart(), resources[0]);
        }
        catch (InvocationTargetException e) {
            CVSUIPlugin.openError(this.getShell(), null, null, e, 12);
        }
        catch (InterruptedException interruptedException) {}
    }

    private IResource[] getDeepResourcesToPatch(IProgressMonitor monitor) throws CoreException {
        ResourceMapping[] mappings = this.getCVSResourceMappings();
        ArrayList<IResource> roots = new ArrayList<IResource>();
        int i = 0;
        while (i < mappings.length) {
            ResourceMapping mapping = mappings[i];
            ResourceTraversal[] traversals = mapping.getTraversals((ResourceMappingContext)SubscriberResourceMappingContext.createContext((Subscriber)CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber()), monitor);
            int j = 0;
            while (j < traversals.length) {
                ResourceTraversal traversal = traversals[j];
                IResource[] resources = traversal.getResources();
                if (traversal.getDepth() == 2) {
                    roots.addAll(Arrays.asList(resources));
                } else if (traversal.getDepth() == 0) {
                    this.collectShallowFiles(resources, roots);
                } else if (traversal.getDepth() == 1) {
                    this.collectShallowFiles(resources, roots);
                    int k = 0;
                    while (k < resources.length) {
                        IResource resource = resources[k];
                        if (resource.getType() != 1) {
                            this.collectShallowFiles(this.members(resource), roots);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return roots.toArray(new IResource[roots.size()]);
    }

    private void collectShallowFiles(IResource[] resources, List<IResource> roots) {
        int k = 0;
        while (k < resources.length) {
            IResource resource = resources[k];
            if (resource.getType() == 1) {
                roots.add(resource);
            }
            ++k;
        }
    }

    private IResource[] members(IResource resource) throws CoreException {
        return CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().members(resource);
    }

    @Override
    protected boolean isEnabledForMultipleResources() {
        return true;
    }

    @Override
    protected boolean isEnabledForUnmanagedResources() {
        return true;
    }

    @Override
    public String getId() {
        return "org.eclipse.team.cvs.ui.GenerateDiff";
    }
}

