/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.team.internal.ccvs.ui.actions.OutgoingChangesDialog;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceTraversalAction;
import org.eclipse.team.internal.ccvs.ui.operations.ReplaceOperation;

public abstract class ReplaceWithTagAction
extends WorkspaceTraversalAction {
    public void execute(IAction action) throws InterruptedException, InvocationTargetException {
        ReplaceOperation replaceOperation = this.createReplaceOperation();
        if (this.hasOutgoingChanges(replaceOperation)) {
            boolean[] keepGoing = new boolean[]{true};
            Display.getDefault().syncExec(() -> {
                OutgoingChangesDialog dialog = new OutgoingChangesDialog(this.getShell(), replaceOperation.getScopeManager(), CVSUIMessages.ReplaceWithTagAction_2, CVSUIMessages.ReplaceWithTagAction_0, CVSUIMessages.ReplaceWithTagAction_1);
                dialog.setHelpContextId("org.eclipse.team.cvs.ui.replace_outgoing_changes_dialog_context");
                int result = dialog.open();
                blArray[0] = result == 0;
            });
            if (!keepGoing[0]) {
                return;
            }
        }
        CVSTag[] tag = new CVSTag[1];
        this.run(monitor -> {
            monitor = Policy.monitorFor(monitor);
            cVSTagArray[0] = this.getTag(replaceOperation);
            if (tag[0] == null) {
                return;
            }
            try {
                if (!CVSAction.checkForMixingTags(this.getShell(), replaceOperation.getScope().getRoots(), tag[0])) {
                    cVSTagArray[0] = null;
                    return;
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }, false, 2);
        if (tag[0] == null) {
            return;
        }
        replaceOperation.setTag(tag[0]);
        replaceOperation.run();
    }

    protected ReplaceOperation createReplaceOperation() {
        return new ReplaceOperation(this.getTargetPart(), this.getCVSResourceMappings(), null);
    }

    @Override
    protected String getErrorTitle() {
        return CVSUIMessages.ReplaceWithTagAction_replace;
    }

    @Override
    protected boolean isEnabledForNonExistantResources() {
        return true;
    }

    protected abstract CVSTag getTag(ReplaceOperation var1);
}

