/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.memories.timely;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.memories.TimestampReplacement;
import org.eclipse.viatra.query.runtime.matchers.memories.timely.AbstractTimelyMaskedMemory;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;

public final class TimelyUnaryMaskedTupleMemory<Timestamp extends Comparable<Timestamp>>
extends AbstractTimelyMaskedMemory<Timestamp, Object> {
    protected final int keyPosition;

    public TimelyUnaryMaskedTupleMemory(TupleMask mask, Object owner) {
        super(mask, owner);
        if (1 != mask.getSize()) {
            throw new IllegalArgumentException(mask.toString());
        }
        this.keyPosition = mask.indices[0];
    }

    @Override
    public Iterable<Tuple> getSignatures() {
        return () -> {
            final Iterator wrapped = this.memory.keySet().iterator();
            return new Iterator<Tuple>(){

                @Override
                public boolean hasNext() {
                    return wrapped.hasNext();
                }

                @Override
                public Tuple next() {
                    Object key = wrapped.next();
                    return Tuples.staticArityFlatTupleOf(key);
                }
            };
        };
    }

    @Override
    public TimestampReplacement<Timestamp> removeWithTimestamp(Tuple tuple, Tuple signature, Timestamp timestamp) {
        Object key = tuple.get(this.keyPosition);
        return this.removeInternal(key, tuple, timestamp);
    }

    @Override
    public TimestampReplacement<Timestamp> addWithTimestamp(Tuple tuple, Tuple signature, Timestamp timestamp) {
        Object key = tuple.get(this.keyPosition);
        return this.addInternal(key, tuple, timestamp);
    }

    @Override
    public Collection<Tuple> get(ITuple signature) {
        return this.getInternal(signature.get(0));
    }

    @Override
    public Map<Tuple, Timestamp> getWithTimestamp(ITuple signature) {
        return this.getWithTimestampInternal(signature.get(0));
    }
}

