/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.gef.policy.layout.form;

import java.util.List;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.internal.core.gef.policy.snapping.IVisualDataProvider;
import org.eclipse.wb.internal.core.gef.policy.snapping.PlacementUtils;
import org.eclipse.wb.internal.core.laf.BaselineSupportHelper;
import org.eclipse.wb.internal.swt.model.layout.form.IFormLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FormLayoutVisualDataProvider<C extends IControlInfo>
implements IVisualDataProvider {
    private final IFormLayoutInfo<C> m_layout;

    public FormLayoutVisualDataProvider(IFormLayoutInfo<C> layout) {
        this.m_layout = layout;
    }

    public int getBaseline(IAbstractComponentInfo component) {
        return BaselineSupportHelper.getBaseline((Object)component.getObject());
    }

    public Dimension getComponentPreferredSize(IAbstractComponentInfo component) {
        IControlInfo componentInfo = (IControlInfo)component;
        return componentInfo.getPreferredSize();
    }

    public Dimension getContainerSize() {
        return this.m_layout.getContainerSize();
    }

    public boolean useGridSnapping() {
        return false;
    }

    public boolean useFreeSnapping() {
        return true;
    }

    public boolean isSuppressingSnapping() {
        return false;
    }

    public int getGridStepY() {
        return this.m_layout.getPreferences().getSnapSensitivity();
    }

    public int getGridStepX() {
        return this.m_layout.getPreferences().getSnapSensitivity();
    }

    public int getContainerGapValue(IAbstractComponentInfo component, int direction) {
        if (PlacementUtils.isHorizontalSide((int)direction)) {
            return this.m_layout.getPreferences().getHorizontalContainerGap();
        }
        return this.m_layout.getPreferences().getVerticalContainerGap();
    }

    public int getComponentGapValue(IAbstractComponentInfo component1, IAbstractComponentInfo component2, int direction) {
        return 6;
    }

    public Point getClientAreaOffset() {
        return this.m_layout.getComposite().getClientArea().getLocation();
    }

    public int getPercentsGap(boolean isHorizontal) {
        return isHorizontal ? this.m_layout.getPreferences().getHorizontalPercentsGap() : this.m_layout.getPreferences().getVerticalPercentsGap();
    }

    public List<Integer> getPercentsValues(boolean isHorizontal) {
        return isHorizontal ? this.m_layout.getPreferences().getHorizontalPercents() : this.m_layout.getPreferences().getVerticalPercents();
    }
}

