"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Red Hat, Inc. All rights reserved.
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
const jsonSchemaService_1 = require("./services/jsonSchemaService");
const documentSymbols_1 = require("./services/documentSymbols");
const yamlCompletion_1 = require("./services/yamlCompletion");
const yamlHover_1 = require("./services/yamlHover");
const yamlValidation_1 = require("./services/yamlValidation");
const yamlFormatter_1 = require("./services/yamlFormatter");
function getLanguageService(schemaRequestService, workspaceContext, contributions, promiseConstructor) {
    let promise = promiseConstructor || Promise;
    let schemaService = new jsonSchemaService_1.JSONSchemaService(schemaRequestService, workspaceContext);
    let completer = new yamlCompletion_1.YAMLCompletion(schemaService, contributions, promise);
    let hover = new yamlHover_1.YAMLHover(schemaService, contributions, promise);
    let yamlDocumentSymbols = new documentSymbols_1.YAMLDocumentSymbols();
    let yamlValidation = new yamlValidation_1.YAMLValidation(schemaService, promise);
    return {
        configure: (settings) => {
            schemaService.clearExternalSchemas();
            if (settings.schemas) {
                settings.schemas.forEach(settings => {
                    schemaService.registerExternalSchema(settings.uri, settings.fileMatch, settings.schema);
                });
            }
            yamlValidation.configure(settings);
            hover.configure(settings);
            let customTagsSetting = settings && settings["customTags"] ? settings["customTags"] : [];
            completer.configure(settings, customTagsSetting);
        },
        registerCustomSchemaProvider: (schemaProvider) => {
            schemaService.registerCustomSchemaProvider(schemaProvider);
        },
        doComplete: completer.doComplete.bind(completer),
        doResolve: completer.doResolve.bind(completer),
        doValidation: yamlValidation.doValidation.bind(yamlValidation),
        doHover: hover.doHover.bind(hover),
        findDocumentSymbols: yamlDocumentSymbols.findDocumentSymbols.bind(yamlDocumentSymbols),
        resetSchema: (uri) => schemaService.onResourceChange(uri),
        doFormat: yamlFormatter_1.format
    };
}
exports.getLanguageService = getLanguageService;
//# sourceMappingURL=yamlLanguageService.js.map