"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Red Hat. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
const vscode_languageserver_1 = require("vscode-languageserver");
const yamlLanguageService_1 = require("../src/languageservice/yamlLanguageService");
const jsonSchemaService_1 = require("../src/languageservice/services/jsonSchemaService");
const testHelper_1 = require("./testHelper");
var assert = require('assert');
let languageService = yamlLanguageService_1.getLanguageService(testHelper_1.schemaRequestService, testHelper_1.workspaceContext, [], null);
let schemaService = new jsonSchemaService_1.JSONSchemaService(testHelper_1.schemaRequestService, testHelper_1.workspaceContext);
let uri = 'http://json.schemastore.org/bowerrc';
let languageSettings = {
    schemas: [],
    validate: true,
    customTags: []
};
let fileMatch = ["*.yml", "*.yaml"];
languageSettings.schemas.push({ uri, fileMatch: fileMatch });
languageSettings.customTags.push("!Test");
languageService.configure(languageSettings);
// Defines a Mocha test suite to group tests of similar kind together
suite("Formatter Tests", () => {
    // Tests for validator
    describe('Formatter', function () {
        function setup(content) {
            return vscode_languageserver_1.TextDocument.create("file://~/Desktop/vscode-k8s/test.yaml", "yaml", 0, content);
        }
        describe('Test that formatter works with custom tags', function () {
            it('Formatting works without custom tags', () => {
                let content = `cwd: test`;
                let testTextDocument = setup(content);
                let edits = languageService.doFormat(testTextDocument, {});
                assert.notEqual(edits.length, 0);
                assert.equal(edits[0].newText, "cwd: test\n");
            });
            it('Formatting works without custom tags', () => {
                let content = `cwd:       !Test test`;
                let testTextDocument = setup(content);
                let edits = languageService.doFormat(testTextDocument, {});
                assert.notEqual(edits.length, 0);
            });
        });
    });
});
//# sourceMappingURL=formatter.test.js.map