/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.perspective;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageBundle {
    private ResourceBundle fResourceBundle;

    public MessageBundle(ResourceBundle resourceBundle) {
        this.fResourceBundle = resourceBundle;
    }

    public String getMessage(String messageId) {
        try {
            return this.fResourceBundle.getString(messageId);
        }
        catch (MissingResourceException missingResourceException) {
            return messageId;
        }
    }

    public String getMessage(String messageId, String sub) {
        String[] s = new String[]{sub};
        return this.getMessage(messageId, s);
    }

    public String getMessage(String messageId, String[] sub) {
        String m = this.getMessage(messageId);
        int len = m.length();
        int max = sub.length;
        StringBuffer b = new StringBuffer();
        int pos = 0;
        while (pos >= 0) {
            int pct = m.indexOf(37, pos);
            if (pct >= 0) {
                b.append(m.substring(pos, pct));
                pos = pct + 1;
                if (pos < len) {
                    char d = m.charAt(pos);
                    if (Character.isDigit(d) && d != '0') {
                        int v = Integer.parseInt(new Character(d).toString());
                        if (v <= max) {
                            b.append(sub[v - 1]);
                        } else {
                            b.append('?');
                        }
                        ++pos;
                        continue;
                    }
                    b.append('%');
                    b.append(d);
                    ++pos;
                    continue;
                }
                b.append('%');
                pos = -1;
                continue;
            }
            b.append(m.substring(pos));
            pos = -1;
        }
        return b.toString();
    }

    public ResourceBundle getResourceBundle() {
        return this.fResourceBundle;
    }
}

