/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import java.util.HashMap;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.table.PlanItem;
import org.h2.table.TableFilter;
import org.h2.util.New;

public class Plan {
    private final TableFilter[] filters;
    private final HashMap<TableFilter, PlanItem> planItems = New.hashMap();
    private final Expression[] allConditions;
    private final TableFilter[] allFilters;

    public Plan(TableFilter[] tableFilterArray, int n, Expression expression) {
        this.filters = new TableFilter[n];
        System.arraycopy(tableFilterArray, 0, this.filters, 0, n);
        final ArrayList<Expression> arrayList = New.arrayList();
        final ArrayList<TableFilter> arrayList2 = New.arrayList();
        if (expression != null) {
            arrayList.add(expression);
        }
        for (int i = 0; i < n; ++i) {
            TableFilter tableFilter = tableFilterArray[i];
            tableFilter.visit(new TableFilter.TableFilterVisitor(){

                public void accept(TableFilter tableFilter) {
                    arrayList2.add(tableFilter);
                    if (tableFilter.getJoinCondition() != null) {
                        arrayList.add(tableFilter.getJoinCondition());
                    }
                }
            });
        }
        this.allConditions = new Expression[arrayList.size()];
        arrayList.toArray(this.allConditions);
        this.allFilters = new TableFilter[arrayList2.size()];
        arrayList2.toArray(this.allFilters);
    }

    public PlanItem getItem(TableFilter tableFilter) {
        return this.planItems.get(tableFilter);
    }

    public TableFilter[] getFilters() {
        return this.filters;
    }

    public void removeUnusableIndexConditions() {
        for (int i = 0; i < this.allFilters.length; ++i) {
            TableFilter tableFilter = this.allFilters[i];
            this.setEvaluatable(tableFilter, true);
            if (i < this.allFilters.length - 1 || tableFilter.getSession().getDatabase().getSettings().earlyFilter) {
                tableFilter.optimizeFullCondition(false);
            }
            tableFilter.removeUnusableIndexConditions();
        }
        for (TableFilter tableFilter : this.allFilters) {
            this.setEvaluatable(tableFilter, false);
        }
    }

    public double calculateCost(Session session) {
        double d = 1.0;
        boolean bl = false;
        int n = 1;
        for (TableFilter tableFilter : this.allFilters) {
            PlanItem planItem = tableFilter.getBestPlanItem(session, n++);
            this.planItems.put(tableFilter, planItem);
            d += d * planItem.cost;
            this.setEvaluatable(tableFilter, true);
            Expression expression = tableFilter.getJoinCondition();
            if (expression == null || expression.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR)) continue;
            bl = true;
            break;
        }
        if (bl) {
            d = Double.POSITIVE_INFINITY;
        }
        for (TableFilter tableFilter : this.allFilters) {
            this.setEvaluatable(tableFilter, false);
        }
        return d;
    }

    private void setEvaluatable(TableFilter tableFilter, boolean bl) {
        tableFilter.setEvaluatable(tableFilter, bl);
        for (Expression expression : this.allConditions) {
            expression.setEvaluatable(tableFilter, bl);
        }
    }
}

