/*******************************************************************************
* Copyright (c) 2007 Actuate Corporation.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*  Actuate Corporation  - initial API and implementation
*******************************************************************************/ 
package org.eclipse.birt.chart.examples.view.models;

import org.eclipse.birt.chart.examples.radar.model.type.RadarSeries;
import org.eclipse.birt.chart.examples.radar.model.type.impl.RadarSeriesImpl;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithoutAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;

/**
 * 
 */

public class Radar
{

	public static final Chart createRadar( )
	{
		ChartWithoutAxes cwoaRadar = ChartWithoutAxesImpl.create( );
		cwoaRadar.setDimension( ChartDimension.TWO_DIMENSIONAL_LITERAL );
		cwoaRadar.setType( "Radar Chart" ); //$NON-NLS-1$	
		cwoaRadar.setSubType( "Standard Radar Chart" ); //$NON-NLS-1$

		// Plot
		cwoaRadar.setSeriesThickness( 10 );

		// Legend
		Legend lg = cwoaRadar.getLegend( );
		lg.getOutline( ).setVisible( true );

		// Title
		cwoaRadar.getTitle( )
				.getLabel( )
				.getCaption( )
				.setValue( "Radar Chart" );//$NON-NLS-1$

		// Data Set
		TextDataSet categoryValues = TextDataSetImpl.create( new String[]{
				"New York", "Boston", "Chicago", "San Francisco", "Dallas"} );//$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
		NumberDataSet seriesOneValues = NumberDataSetImpl.create( new double[]{
				54, 21, 75, 91, 37
		} );

		SampleData sdata = DataFactory.eINSTANCE.createSampleData( );
		BaseSampleData sdBase = DataFactory.eINSTANCE.createBaseSampleData( );
		sdBase.setDataSetRepresentation( "" );//$NON-NLS-1$
		sdata.getBaseSampleData( ).add( sdBase );

		OrthogonalSampleData sdOrthogonal = DataFactory.eINSTANCE.createOrthogonalSampleData( );
		sdOrthogonal.setDataSetRepresentation( "" );//$NON-NLS-1$
		sdOrthogonal.setSeriesDefinitionIndex( 0 );
		sdata.getOrthogonalSampleData( ).add( sdOrthogonal );

		cwoaRadar.setSampleData( sdata );

		// Base Series
		Series seCategory = SeriesImpl.create( );
		seCategory.setDataSet( categoryValues );

		SeriesDefinition sd = SeriesDefinitionImpl.create( );
		cwoaRadar.getSeriesDefinitions( ).add( sd );
		sd.getSeriesPalette( ).shift( 0 );
		sd.getSeries( ).add( seCategory );

		// Orthogonal Series
		RadarSeries seRadar = RadarSeriesImpl.create( );
		seRadar.setDataSet( seriesOneValues );
		seRadar.setSeriesIdentifier( "Cities" );//$NON-NLS-1$ 
		seRadar.getLabel( ).setVisible( true );

		SeriesDefinition sdCity = SeriesDefinitionImpl.create( );
		sd.getSeriesDefinitions( ).add( sdCity );
		sdCity.getSeries( ).add( seRadar );

		return cwoaRadar;
	}
}
