/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.containers;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.bpmn2.modeler.core.features.label.UpdateLabelFeature;
import org.eclipse.bpmn2.modeler.core.preferences.ShapeStyle;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class UpdateContainerLabelFeature
extends UpdateLabelFeature {
    public UpdateContainerLabelFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    protected ShapeStyle.LabelPosition getLabelPosition(AbstractText text) {
        if (text.getAngle() == -90) {
            return ShapeStyle.LabelPosition.LEFT;
        }
        return ShapeStyle.LabelPosition.TOP;
    }

    @Override
    protected int getLabelWidth(AbstractText text) {
        if (text.getAngle() == -90) {
            return this.getLabelSize((AbstractText)text).height;
        }
        return this.getLabelSize((AbstractText)text).width;
    }

    @Override
    protected int getLabelHeight(AbstractText text) {
        if (text.getAngle() == -90) {
            return this.getLabelSize((AbstractText)text).width;
        }
        return this.getLabelSize((AbstractText)text).height;
    }

    @Override
    public boolean update(IUpdateContext context) {
        Hashtable offsetMap = (Hashtable)context.getProperty((Object)"label.offset.map");
        Point offset = (Point)context.getProperty((Object)"label.offset");
        boolean isAdding = this.isAddingLabel((IContext)context);
        PictogramElement ownerPE = FeatureSupport.getLabelOwner((IContext)context);
        boolean isHorizontal = FeatureSupport.isHorizontal((ContainerShape)ownerPE);
        Shape labelShape = FeatureSupport.getLabelShape(ownerPE);
        AbstractText textGA = (AbstractText)labelShape.getGraphicsAlgorithm();
        textGA.setRotation(Double.valueOf(isHorizontal ? -90.0 : 0.0));
        ContainerShape rootContainer = FeatureSupport.getRootContainer((ContainerShape)ownerPE);
        super.adjustLabelLocation((PictogramElement)rootContainer, isAdding, offset);
        ArrayList<PictogramElement> peList = new ArrayList<PictogramElement>();
        TreeIterator iter = rootContainer.eAllContents();
        while (iter.hasNext()) {
            PictogramElement pe;
            EObject o = (EObject)iter.next();
            if (!(o instanceof PictogramElement) || !FeatureSupport.hasBPMNShape(pe = (PictogramElement)o) && !FeatureSupport.hasBPMNEdge(pe)) continue;
            peList.add(pe);
        }
        for (PictogramElement pe : peList) {
            Point p;
            if (FeatureSupport.hasBPMNShape(pe)) {
                if (FeatureSupport.isLane(pe)) {
                    labelShape = FeatureSupport.getLabelShape(pe);
                    textGA = (AbstractText)labelShape.getGraphicsAlgorithm();
                    textGA.setRotation(Double.valueOf(isHorizontal ? -90.0 : 0.0));
                    super.adjustLabelLocation(pe, isAdding, offset);
                    continue;
                }
                p = offsetMap == null ? null : (Point)offsetMap.get(pe);
                FeatureSupport.updateLabel(this.getFeatureProvider(), pe, p);
                continue;
            }
            if (!FeatureSupport.hasBPMNEdge(pe)) continue;
            p = offsetMap == null ? null : (Point)offsetMap.get(pe);
            FeatureSupport.updateLabel(this.getFeatureProvider(), pe, p);
        }
        return true;
    }

    @Override
    protected ContainerShape getTargetContainer(PictogramElement ownerPE) {
        return (ContainerShape)ownerPE.eContainer();
    }
}

