/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.model;

import java.util.HashMap;
import org.eclipse.bpmn2.modeler.core.model.ModelHandler;
import org.eclipse.bpmn2.util.Bpmn2ResourceImpl;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class ModelHandlerLocator {
    private static HashMap<URI, ModelHandler> map = new HashMap();
    private static HashMap<URI, ModelHandler> diagramMap = new HashMap();

    public static ModelHandler getModelHandler(Resource eResource) {
        if (eResource == null) {
            return null;
        }
        URI uri = eResource.getURI().trimFragment();
        return ModelHandlerLocator.getModelHandler(uri);
    }

    public static ModelHandler getModelHandler(URI path) {
        ModelHandler modelHandler = map.get(path = path.trimFragment());
        if (modelHandler == null) {
            return diagramMap.get(path);
        }
        return modelHandler;
    }

    public static void put(URI diagramPath, ModelHandler mh) {
        diagramMap.put(diagramPath.trimFragment(), mh);
    }

    public static void remove(URI path) {
        if (map.remove(path = path.trimFragment()) == null) {
            diagramMap.remove(path);
        }
    }

    public static ModelHandler createModelHandler(URI path, Bpmn2ResourceImpl resource) {
        if (map.containsKey(path = path.trimFragment())) {
            return map.get(path);
        }
        return ModelHandlerLocator.createNewModelHandler(path, resource);
    }

    private static ModelHandler createNewModelHandler(URI path, Bpmn2ResourceImpl resource) {
        ModelHandler handler = new ModelHandler();
        path = path.trimFragment();
        map.put(path, handler);
        handler.resource = resource;
        URI uri = resource.getURI();
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            String platformString = uri.toPlatformString(true);
            if ((platformString == null || workspace.getRoot().getFile((IPath)new Path(platformString)).exists()) && !resource.isLoaded()) {
                handler.loadResource();
            }
        }
        catch (IllegalStateException illegalStateException) {
            if (!resource.isLoaded()) {
                handler.loadResource();
            }
        }
        catch (Exception exception) {}
        handler.createDefinitionsIfMissing();
        return handler;
    }

    public static void dispose(ModelHandler modelHandler) {
        ModelHandlerLocator.remove(modelHandler.getResource().getURI());
    }
}

