/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.ui.view.actions;

import java.util.Iterator;
import org.eclipse.cdt.testsrunner.internal.ui.view.TestPathUtils;
import org.eclipse.cdt.testsrunner.internal.ui.view.actions.ActionsMessages;
import org.eclipse.cdt.testsrunner.model.ITestItem;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class CopySelectedTestsAction
extends Action {
    private TreeViewer treeViewer;
    private Clipboard clipboard;

    public CopySelectedTestsAction(TreeViewer treeViewer, Clipboard clipboard) {
        super(ActionsMessages.CopySelectedTestsAction_text);
        this.setToolTipText(ActionsMessages.CopySelectedTestsAction_tooltip);
        this.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.treeViewer = treeViewer;
        this.clipboard = clipboard;
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        if (!selection.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            boolean needEOL = false;
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                if (needEOL) {
                    sb.append(System.getProperty("line.separator"));
                } else {
                    needEOL = true;
                }
                sb.append(TestPathUtils.getTestItemPath((ITestItem)it.next()));
            }
            this.clipboard.setContents((Object[])new String[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
        }
    }
}

