/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.impl;

import org.eclipse.core.runtime.IStatus;

import org.eclipse.e4.core.contexts.IEclipseContext;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EcoreUtil;

import org.eclipse.epp.internal.logging.aeri.ide.IIdePackage;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEvent;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup;
import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;

import org.eclipse.epp.logging.aeri.core.IProblemState;
import org.eclipse.epp.logging.aeri.core.ISendOptions;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Log Event</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.LogEventImpl#getStatus <em>Status</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.LogEventImpl#getLabel <em>Label</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.LogEventImpl#getServer <em>Server</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.LogEventImpl#getGroup <em>Group</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.LogEventImpl#getInterest <em>Interest</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.LogEventImpl#getOptions <em>Options</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.LogEventImpl#getResponse <em>Response</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.LogEventImpl#getContext <em>Context</em>}</li>
 * </ul>
 *
 * @generated
 */
public class LogEventImpl extends MinimalEObjectImpl.Container implements ILogEvent {
	/**
	 * The default value of the '{@link #getStatus() <em>Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStatus()
	 * @generated
	 * @ordered
	 */
	protected static final IStatus STATUS_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getStatus() <em>Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStatus()
	 * @generated
	 * @ordered
	 */
	protected IStatus status = STATUS_EDEFAULT;

	/**
	 * The default value of the '{@link #getLabel() <em>Label</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLabel()
	 * @generated
	 * @ordered
	 */
	protected static final String LABEL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLabel() <em>Label</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLabel()
	 * @generated
	 * @ordered
	 */
	protected String label = LABEL_EDEFAULT;

	/**
	 * The cached value of the '{@link #getServer() <em>Server</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getServer()
	 * @generated
	 * @ordered
	 */
	protected IServerDescriptor server;

	/**
	 * The cached value of the '{@link #getInterest() <em>Interest</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInterest()
	 * @generated
	 * @ordered
	 */
	protected IProblemState interest;

	/**
	 * The cached value of the '{@link #getOptions() <em>Options</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOptions()
	 * @generated
	 * @ordered
	 */
	protected ISendOptions options;

	/**
	 * The cached value of the '{@link #getResponse() <em>Response</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getResponse()
	 * @generated
	 * @ordered
	 */
	protected IProblemState response;

	/**
	 * The default value of the '{@link #getContext() <em>Context</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContext()
	 * @generated
	 * @ordered
	 */
	protected static final IEclipseContext CONTEXT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getContext() <em>Context</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContext()
	 * @generated
	 * @ordered
	 */
	protected IEclipseContext context = CONTEXT_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LogEventImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IIdePackage.Literals.LOG_EVENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IStatus getStatus() {
		return status;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStatus(IStatus newStatus) {
		IStatus oldStatus = status;
		status = newStatus;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.LOG_EVENT__STATUS, oldStatus, status));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLabel() {
		return label;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLabel(String newLabel) {
		String oldLabel = label;
		label = newLabel;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.LOG_EVENT__LABEL, oldLabel, label));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IServerDescriptor getServer() {
		if (server != null && server.eIsProxy()) {
			InternalEObject oldServer = (InternalEObject)server;
			server = (IServerDescriptor)eResolveProxy(oldServer);
			if (server != oldServer) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, IIdePackage.LOG_EVENT__SERVER, oldServer, server));
			}
		}
		return server;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IServerDescriptor basicGetServer() {
		return server;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setServer(IServerDescriptor newServer) {
		IServerDescriptor oldServer = server;
		server = newServer;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.LOG_EVENT__SERVER, oldServer, server));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ILogEventGroup getGroup() {
		if (eContainerFeatureID() != IIdePackage.LOG_EVENT__GROUP) return null;
		return (ILogEventGroup)eInternalContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetGroup(ILogEventGroup newGroup, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newGroup, IIdePackage.LOG_EVENT__GROUP, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setGroup(ILogEventGroup newGroup) {
		if (newGroup != eInternalContainer() || (eContainerFeatureID() != IIdePackage.LOG_EVENT__GROUP && newGroup != null)) {
			if (EcoreUtil.isAncestor(this, newGroup))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newGroup != null)
				msgs = ((InternalEObject)newGroup).eInverseAdd(this, IIdePackage.LOG_EVENT_GROUP__EVENTS, ILogEventGroup.class, msgs);
			msgs = basicSetGroup(newGroup, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.LOG_EVENT__GROUP, newGroup, newGroup));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IProblemState getInterest() {
		if (interest != null && interest.eIsProxy()) {
			InternalEObject oldInterest = (InternalEObject)interest;
			interest = (IProblemState)eResolveProxy(oldInterest);
			if (interest != oldInterest) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, IIdePackage.LOG_EVENT__INTEREST, oldInterest, interest));
			}
		}
		return interest;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IProblemState basicGetInterest() {
		return interest;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInterest(IProblemState newInterest) {
		IProblemState oldInterest = interest;
		interest = newInterest;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.LOG_EVENT__INTEREST, oldInterest, interest));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ISendOptions getOptions() {
		if (options != null && options.eIsProxy()) {
			InternalEObject oldOptions = (InternalEObject)options;
			options = (ISendOptions)eResolveProxy(oldOptions);
			if (options != oldOptions) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, IIdePackage.LOG_EVENT__OPTIONS, oldOptions, options));
			}
		}
		return options;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ISendOptions basicGetOptions() {
		return options;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOptions(ISendOptions newOptions) {
		ISendOptions oldOptions = options;
		options = newOptions;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.LOG_EVENT__OPTIONS, oldOptions, options));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IProblemState getResponse() {
		if (response != null && response.eIsProxy()) {
			InternalEObject oldResponse = (InternalEObject)response;
			response = (IProblemState)eResolveProxy(oldResponse);
			if (response != oldResponse) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, IIdePackage.LOG_EVENT__RESPONSE, oldResponse, response));
			}
		}
		return response;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IProblemState basicGetResponse() {
		return response;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setResponse(IProblemState newResponse) {
		IProblemState oldResponse = response;
		response = newResponse;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.LOG_EVENT__RESPONSE, oldResponse, response));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IEclipseContext getContext() {
		return context;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setContext(IEclipseContext newContext) {
		IEclipseContext oldContext = context;
		context = newContext;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.LOG_EVENT__CONTEXT, oldContext, context));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IIdePackage.LOG_EVENT__GROUP:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetGroup((ILogEventGroup)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IIdePackage.LOG_EVENT__GROUP:
				return basicSetGroup(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case IIdePackage.LOG_EVENT__GROUP:
				return eInternalContainer().eInverseRemove(this, IIdePackage.LOG_EVENT_GROUP__EVENTS, ILogEventGroup.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IIdePackage.LOG_EVENT__STATUS:
				return getStatus();
			case IIdePackage.LOG_EVENT__LABEL:
				return getLabel();
			case IIdePackage.LOG_EVENT__SERVER:
				if (resolve) return getServer();
				return basicGetServer();
			case IIdePackage.LOG_EVENT__GROUP:
				return getGroup();
			case IIdePackage.LOG_EVENT__INTEREST:
				if (resolve) return getInterest();
				return basicGetInterest();
			case IIdePackage.LOG_EVENT__OPTIONS:
				if (resolve) return getOptions();
				return basicGetOptions();
			case IIdePackage.LOG_EVENT__RESPONSE:
				if (resolve) return getResponse();
				return basicGetResponse();
			case IIdePackage.LOG_EVENT__CONTEXT:
				return getContext();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IIdePackage.LOG_EVENT__STATUS:
				setStatus((IStatus)newValue);
				return;
			case IIdePackage.LOG_EVENT__LABEL:
				setLabel((String)newValue);
				return;
			case IIdePackage.LOG_EVENT__SERVER:
				setServer((IServerDescriptor)newValue);
				return;
			case IIdePackage.LOG_EVENT__GROUP:
				setGroup((ILogEventGroup)newValue);
				return;
			case IIdePackage.LOG_EVENT__INTEREST:
				setInterest((IProblemState)newValue);
				return;
			case IIdePackage.LOG_EVENT__OPTIONS:
				setOptions((ISendOptions)newValue);
				return;
			case IIdePackage.LOG_EVENT__RESPONSE:
				setResponse((IProblemState)newValue);
				return;
			case IIdePackage.LOG_EVENT__CONTEXT:
				setContext((IEclipseContext)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IIdePackage.LOG_EVENT__STATUS:
				setStatus(STATUS_EDEFAULT);
				return;
			case IIdePackage.LOG_EVENT__LABEL:
				setLabel(LABEL_EDEFAULT);
				return;
			case IIdePackage.LOG_EVENT__SERVER:
				setServer((IServerDescriptor)null);
				return;
			case IIdePackage.LOG_EVENT__GROUP:
				setGroup((ILogEventGroup)null);
				return;
			case IIdePackage.LOG_EVENT__INTEREST:
				setInterest((IProblemState)null);
				return;
			case IIdePackage.LOG_EVENT__OPTIONS:
				setOptions((ISendOptions)null);
				return;
			case IIdePackage.LOG_EVENT__RESPONSE:
				setResponse((IProblemState)null);
				return;
			case IIdePackage.LOG_EVENT__CONTEXT:
				setContext(CONTEXT_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IIdePackage.LOG_EVENT__STATUS:
				return STATUS_EDEFAULT == null ? status != null : !STATUS_EDEFAULT.equals(status);
			case IIdePackage.LOG_EVENT__LABEL:
				return LABEL_EDEFAULT == null ? label != null : !LABEL_EDEFAULT.equals(label);
			case IIdePackage.LOG_EVENT__SERVER:
				return server != null;
			case IIdePackage.LOG_EVENT__GROUP:
				return getGroup() != null;
			case IIdePackage.LOG_EVENT__INTEREST:
				return interest != null;
			case IIdePackage.LOG_EVENT__OPTIONS:
				return options != null;
			case IIdePackage.LOG_EVENT__RESPONSE:
				return response != null;
			case IIdePackage.LOG_EVENT__CONTEXT:
				return CONTEXT_EDEFAULT == null ? context != null : !CONTEXT_EDEFAULT.equals(context);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (status: ");
		result.append(status);
		result.append(", label: ");
		result.append(label);
		result.append(", context: ");
		result.append(context);
		result.append(')');
		return result.toString();
	}

} //LogEventImpl
