/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.notifications;

import com.google.common.collect.Lists;
import java.text.ChoiceFormat;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.handlers.OpenServersSetupWizardHandler;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.Messages;
import org.eclipse.epp.internal.logging.aeri.ide.notifications.Notification;
import org.eclipse.epp.internal.logging.aeri.ide.notifications.NotificationAction;
import org.eclipse.epp.internal.logging.aeri.ide.utils.Formats;
import org.eclipse.epp.logging.aeri.core.SystemControl;

public class SetupNewServersNotification
extends Notification {
    private List<IServerDescriptor> servers;
    private IEclipseContext context;
    private OpenServersSetupWizardHandler handler;

    @Inject
    public SetupNewServersNotification(IEventBroker broker, IEclipseContext context) {
        super("org.eclipse.epp.logging.aeri.notifications.event.setup", broker);
        this.context = context;
        this.handler = this.handler;
    }

    @Override
    public List<NotificationAction> getActions() {
        NotificationAction a1 = new NotificationAction(Messages.NOTIFICATION_ACTION_ENABLE){

            @Override
            public void execute() {
                SetupNewServersNotification.this.closeWithEvent(null, null);
                SystemControl.executeHandler(OpenServersSetupWizardHandler.class);
            }
        };
        NotificationAction a2 = new NotificationAction(Messages.NOTIFICATION_ACTION_DISABLE){

            @Override
            public void execute() {
                SetupNewServersNotification.this.closeWithEvent("org/eclipse/epp/internal/logging/aeri/ui/servers/disabled", null);
            }
        };
        return Lists.newArrayList((Object[])new NotificationAction[]{a1, a2});
    }

    @Override
    public String getTitle() {
        return this.title0();
    }

    public String getLabel() {
        return Messages.NOTIFICATION_LABEL_SETUP_NEW_SERVERS;
    }

    private String title0() {
        String name = this.servers.get(0).getName();
        double[] limits = new double[]{1.0, 2.0, 3.0, 4.0};
        String[] formats = new String[]{"", Messages.NOTIFICATION_TITLE_SETUP_NEW_SERVERS_1_ADDITIONAL_SERVER, Messages.NOTIFICATION_TITLE_SETUP_NEW_SERVERS_2_ADDITIONAL_SERVERS, Formats.format(Messages.NOTIFICATION_TITLE_SETUP_NEW_SERVERS_X_ADDITIONAL_SERVERS, this.servers.size() - 1)};
        String start = new ChoiceFormat(limits, formats).format(this.servers.size());
        return Formats.format(Messages.NOTIFICATION_TITLE_SETUP_NEW_SERVERS, name, start);
    }

    public String getDescription() {
        return Formats.format(Messages.NOTIFICATION_DESCRIPTION_SETUP_NEW_SERVERS, this.servers.size());
    }

    public void setServers(List<IServerDescriptor> servers) {
        this.servers = servers;
    }
}

