/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.core.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.internal.l10n.DiagramCoreMessages;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class UpdateGroupLocationCommand
extends AbstractTransactionalCommand {
    private View groupView;

    public UpdateGroupLocationCommand(TransactionalEditingDomain domain, View groupView) {
        super(domain, DiagramCoreMessages.UpdateLocation_Label, UpdateGroupLocationCommand.getWorkspaceFiles((EObject)groupView));
        this.groupView = groupView;
    }

    protected View getGroupView() {
        return this.groupView;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.updateGroupLocation(this.getGroupView());
        EObject container = this.getGroupView().eContainer();
        while (container instanceof View && ViewType.GROUP.equals(((View)container).getType())) {
            this.updateGroupLocation((View)container);
            container = ((View)container).eContainer();
        }
        return CommandResult.newOKCommandResult();
    }

    private void updateGroupLocation(View group) {
        int minChildX = Integer.MAX_VALUE;
        int minChildY = Integer.MAX_VALUE;
        for (View childView : group.getChildren()) {
            LayoutConstraint layoutConstraint;
            if (!(childView instanceof Node) || !((layoutConstraint = ((Node)childView).getLayoutConstraint()) instanceof Location)) continue;
            Location childLocation = (Location)layoutConstraint;
            if (childLocation.getX() < minChildX) {
                minChildX = childLocation.getX();
            }
            if (childLocation.getY() >= minChildY) continue;
            minChildY = childLocation.getY();
        }
        if (minChildX != 0) {
            Integer x = (Integer)ViewUtil.getStructuralFeatureValue(group, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
            ViewUtil.setStructuralFeatureValue(group, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), new Integer(x + minChildX));
            for (View childView : group.getChildren()) {
                x = (Integer)ViewUtil.getStructuralFeatureValue(childView, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
                ViewUtil.setStructuralFeatureValue(childView, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), new Integer(x - minChildX));
            }
        }
        if (minChildY != 0) {
            Integer y = (Integer)ViewUtil.getStructuralFeatureValue(group, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
            ViewUtil.setStructuralFeatureValue(group, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y(), new Integer(y + minChildY));
            for (View childView : group.getChildren()) {
                y = (Integer)ViewUtil.getStructuralFeatureValue(childView, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
                ViewUtil.setStructuralFeatureValue(childView, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y(), y - minChildY);
            }
        }
    }
}

