/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.INumberBeanProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.remote.REMFloatTypeBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMPrimitiveBeanTypeProxy;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;

final class REMFloatTypeBeanTypeProxy
extends REMPrimitiveBeanTypeProxy {
    private final INumberBeanProxy zeroProxy;

    REMFloatTypeBeanTypeProxy(REMProxyFactoryRegistry aRegistry) {
        super(aRegistry, new Integer(11), Float.TYPE.getName());
        this.zeroProxy = new REMFloatTypeBeanProxy(aRegistry, 0.0f);
    }

    INumberBeanProxy createFloatBeanProxy(float aFloat) {
        return aFloat != 0.0f ? new REMFloatTypeBeanProxy(this.fRegistry, aFloat) : this.zeroProxy;
    }

    public IBeanProxy newInstance() {
        return this.zeroProxy;
    }

    public IBeanProxy newBeanProxy(Commands.ValueObject value) {
        return this.createFloatBeanProxy(value.aFloat);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IBeanProxy newInstance(String initializationString) throws ThrowableProxy, ClassCastException, InstantiationException {
        float aFloat;
        String trim = initializationString.trim();
        if (trim.length() == 0) {
            return super.newInstance(initializationString);
        }
        if (trim.startsWith("(float)")) {
            Number v = REMFloatTypeBeanTypeProxy.parseString(trim.substring("(float)".length()).trim());
            if (v == null) return super.newInstance(initializationString);
            aFloat = v.floatValue();
            return this.getProxyFactoryRegistry().getBeanProxyFactory().createBeanProxyWith(aFloat);
        }
        try {
            aFloat = Float.valueOf(initializationString).floatValue();
            return this.getProxyFactoryRegistry().getBeanProxyFactory().createBeanProxyWith(aFloat);
        }
        catch (NumberFormatException numberFormatException) {
            return super.newInstance(initializationString);
        }
    }
}

