/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.workbench.utility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.internal.core.JEMPlugin;

public abstract class JavaModelListener
implements IElementChangedListener {
    private HashMap resolvedContainers = new HashMap();

    public JavaModelListener() {
        this(1);
    }

    public JavaModelListener(int eventsToListen) {
        JavaCore.addElementChangedListener((IElementChangedListener)this, (int)eventsToListen);
    }

    public void elementChanged(ElementChangedEvent event) {
        this.processDelta((IJavaElementDelta)event.getSource());
    }

    protected void processChildren(IJavaElement element, IJavaElementDelta delta) {
        IJavaElementDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            this.processDelta(children[i]);
            ++i;
        }
    }

    protected void processContentChanged(IJavaElementDelta delta) {
    }

    public void processDelta(IJavaElementDelta delta) {
        IJavaElement element = delta.getElement();
        int flags = delta.getFlags();
        if ((flags & 0x200000) != 0 && !this.resolvedContainers.isEmpty()) {
            this.resolvedContainers.clear();
        }
        switch (element.getElementType()) {
            case 1: {
                this.processJavaElementChanged((IJavaModel)element, delta);
                break;
            }
            case 2: {
                this.processJavaElementChanged((IJavaProject)element, delta);
                break;
            }
            case 3: {
                this.processJavaElementChanged((IPackageFragmentRoot)element, delta);
                break;
            }
            case 4: {
                this.processJavaElementChanged((IPackageFragment)element, delta);
                break;
            }
            case 5: {
                this.processJavaElementChanged((ICompilationUnit)element, delta);
                this.processContentChanged(delta);
                break;
            }
            case 6: {
                this.processJavaElementChanged((IClassFile)element, delta);
                break;
            }
            case 7: {
                this.processJavaElementChanged((IType)element, delta);
            }
        }
    }

    protected void processJavaElementChanged(IClassFile element, IJavaElementDelta delta) {
    }

    protected void processJavaElementChanged(ICompilationUnit element, IJavaElementDelta delta) {
        this.processChildren((IJavaElement)element, delta);
    }

    protected void processJavaElementChanged(IJavaModel element, IJavaElementDelta delta) {
        this.processChildren((IJavaElement)element, delta);
    }

    protected void processJavaElementChanged(IJavaProject element, IJavaElementDelta delta) {
        this.processChildren((IJavaElement)element, delta);
    }

    protected void processJavaElementChanged(IPackageFragment element, IJavaElementDelta delta) {
        this.processChildren((IJavaElement)element, delta);
    }

    protected void processJavaElementChanged(IPackageFragmentRoot element, IJavaElementDelta delta) {
        this.processChildren((IJavaElement)element, delta);
    }

    protected void processJavaElementChanged(IType element, IJavaElementDelta delta) {
    }

    protected boolean isClassPathChange(IJavaElementDelta delta) {
        int flags = delta.getFlags();
        return delta.getKind() == 4 && (flags & 0x40) != 0 || (flags & 0x80) != 0 || (flags & 0x100) != 0;
    }

    protected boolean isClasspathResourceChange(IJavaElementDelta delta) {
        if ((delta.getFlags() & 0x20000) != 0) {
            return true;
        }
        IResourceDelta[] resources = delta.getResourceDeltas();
        if (resources == null) {
            return false;
        }
        IPath path = null;
        int i = 0;
        while (i < resources.length) {
            if (resources[i].getKind() == 4 && this.isAlsoClasspathChange(path = resources[i].getProjectRelativePath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isAlsoClasspathChange(IPath path) {
        return false;
    }

    protected boolean isInClasspath(IJavaProject javaProject) {
        IJavaProject listenerJavaProject = this.getJavaProject();
        if (javaProject.equals(listenerJavaProject)) {
            return true;
        }
        return this.isInClasspath(javaProject, listenerJavaProject, true, new HashSet());
    }

    protected abstract IJavaProject getJavaProject();

    protected boolean isInClasspath(IJavaProject testProject, IJavaProject targetProject, boolean isFirstLevel, Set visited) {
        if (visited.contains(targetProject)) {
            return false;
        }
        visited.add(targetProject);
        IClasspathEntry[] entries = null;
        try {
            entries = targetProject.getRawClasspath();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        ArrayList<IJavaProject> projects = null;
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            switch (entry.getEntryKind()) {
                case 2: {
                    IJavaProject entryProject = this.getVisibleJavaProject(entry, isFirstLevel);
                    if (entryProject == null) break;
                    if (entryProject.equals(testProject)) {
                        return true;
                    }
                    if (projects == null) {
                        projects = new ArrayList<IJavaProject>();
                    }
                    projects.add(entryProject);
                    break;
                }
                case 5: {
                    IClasspathContainer container = null;
                    try {
                        container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)targetProject);
                    }
                    catch (JavaModelException e) {
                        JEMPlugin.getPlugin().getLogger().logError((Throwable)e);
                    }
                    if (container == null || container.getKind() != 1) break;
                    IClasspathEntry[] containerEntries = null;
                    containerEntries = (IClasspathEntry[])this.resolvedContainers.get(container);
                    if (containerEntries == null) {
                        containerEntries = container.getClasspathEntries();
                        this.resolvedContainers.put(container, containerEntries);
                    }
                    int j = 0;
                    while (j < containerEntries.length) {
                        IJavaProject conEntryProject;
                        if (containerEntries[j].getEntryKind() == 2 && (conEntryProject = this.getVisibleJavaProject(containerEntries[j], isFirstLevel)) != null) {
                            if (conEntryProject.equals(testProject)) {
                                return true;
                            }
                            if (projects == null) {
                                projects = new ArrayList();
                            }
                            projects.add(conEntryProject);
                        }
                        ++j;
                    }
                    break;
                }
            }
            ++i;
        }
        return this.isInClasspath(testProject, projects, false, visited);
    }

    private IJavaProject getVisibleJavaProject(IClasspathEntry entry, boolean isFirstLevel) {
        if (isFirstLevel || entry.isExported()) {
            IClasspathEntry resEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
            return this.getJavaProject(resEntry);
        }
        return null;
    }

    protected boolean isInClasspath(IJavaProject testProject, List someJavaProjects, boolean isFirstLevel, Set visited) {
        if (someJavaProjects == null) {
            return false;
        }
        int size = someJavaProjects.size();
        IJavaProject javaProj = null;
        boolean result = false;
        int i = 0;
        while (i < size) {
            javaProj = (IJavaProject)someJavaProjects.get(i);
            result = this.isInClasspath(testProject, javaProj, isFirstLevel, visited);
            if (result) break;
            ++i;
        }
        return result;
    }

    protected IJavaProject getJavaProject(IClasspathEntry entry) {
        IProject proj = this.getWorkspaceRoot().getProject(entry.getPath().segment(0));
        if (proj != null) {
            return JavaCore.create((IProject)proj);
        }
        return null;
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

