/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.components;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * Interface representing the ComboComponent component from the concrete toolkit. 
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 * 
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ComponentClassGenerator", 
           date =  "2019-09-03T07:24:07.041Z")
public interface ComboComponent extends org.eclipse.jubula.toolkit.base.components.TextInputComponent {
    
    
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfEntryByValue(@NonNull String text,@NonNull Operator operator,@NonNull Boolean exists,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException;
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfEntryByValue(@NonNull String text,@NonNull Operator operator,@NonNull Boolean exists
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfEntryByIndex(@NonNull String index,@NonNull Boolean selected,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException;
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param selected 
         *        whether the component is expected to be selected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfEntryByIndex(@NonNull String index,@NonNull Boolean selected
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param index 
         *        the 1-based index
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP selectEntryByIndex(@NonNull String index
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param searchType 
         *        the search type
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP selectEntryByValue(@NonNull String text,@NonNull Operator operator,@NonNull SearchType searchType
        ) throws IllegalArgumentException;
        
} 