/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.internal.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang.StringUtils;

public class ZipUtil {
    private static final String JAR_FILE_EXT = ".jar";
    private static Map<File, File[]> zipToTempJars = new HashMap<File, File[]>();

    private ZipUtil() {
    }

    public static final void zipDirectory(File directory, File zip) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zip));
        ZipUtil.zip(directory, directory, zos);
        zos.close();
    }

    private static final void zip(File directory, File base, ZipOutputStream zos) throws IOException {
        File[] files = directory.listFiles();
        byte[] buffer = new byte[8192];
        int read = 0;
        int i = 0;
        int n = files.length;
        while (i < n) {
            if (files[i].isDirectory()) {
                ZipUtil.zip(files[i], base, zos);
            } else {
                FileInputStream in = new FileInputStream(files[i]);
                ZipEntry entry = new ZipEntry(files[i].getPath().substring(base.getPath().length() + 1));
                zos.putNextEntry(entry);
                while (-1 != (read = in.read(buffer))) {
                    zos.write(buffer, 0, read);
                }
                in.close();
            }
            ++i;
        }
    }

    public static final void unzip(File zip, File extractTo) throws IOException {
        ZipUtil.unzipFiles(zip, extractTo, new IZipEntryFilter(){

            public boolean accept(ZipEntry entry) {
                return true;
            }
        });
    }

    public static File[] unzipTempJars(File srcZip) throws IOException {
        if (zipToTempJars.containsKey(srcZip)) {
            return zipToTempJars.get(srcZip);
        }
        IZipEntryFilter filter = new IZipEntryFilter(){

            public boolean accept(ZipEntry entry) {
                return entry.getName().toLowerCase().endsWith(ZipUtil.JAR_FILE_EXT);
            }
        };
        ZipFile archive = new ZipFile(srcZip);
        Enumeration<? extends ZipEntry> e = archive.entries();
        ArrayList<File> extractedFiles = new ArrayList<File>();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (!filter.accept(entry) || entry.isDirectory()) continue;
            String prefix = entry.getName().substring(entry.getName().lastIndexOf("/") + 1, entry.getName().toLowerCase().lastIndexOf(JAR_FILE_EXT));
            File file = File.createTempFile(StringUtils.rightPad((String)prefix, (int)3), JAR_FILE_EXT);
            extractedFiles.add(file);
            file.deleteOnExit();
            ZipUtil.unzipFile(archive, file, entry);
        }
        File[] files = extractedFiles.toArray(new File[extractedFiles.size()]);
        zipToTempJars.put(srcZip, files);
        return files;
    }

    public static File[] unzipFiles(File srcZip, File targetDir, IZipEntryFilter filter) throws IOException {
        ZipFile archive = new ZipFile(srcZip);
        Enumeration<? extends ZipEntry> e = archive.entries();
        ArrayList<File> extractedFiles = new ArrayList<File>();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (!filter.accept(entry)) continue;
            File file = new File(targetDir, entry.getName());
            if (entry.isDirectory() && !file.exists()) {
                file.mkdirs();
                continue;
            }
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            extractedFiles.add(file);
            ZipUtil.unzipFile(archive, file, entry);
        }
        return extractedFiles.toArray(new File[extractedFiles.size()]);
    }

    private static void unzipFile(ZipFile archive, File targetFile, ZipEntry entry) throws IOException {
        InputStream in = null;
        FilterOutputStream out = null;
        try {
            int read;
            in = archive.getInputStream(entry);
            out = new BufferedOutputStream(new FileOutputStream(targetFile));
            byte[] buffer = new byte[8192];
            while (-1 != (read = in.read(buffer))) {
                ((BufferedOutputStream)out).write(buffer, 0, read);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static interface IZipEntryFilter {
        public boolean accept(ZipEntry var1);
    }
}

