/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.debug.ui.internal;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.variables.details.DetailPaneAssignValueAction;
import org.eclipse.debug.internal.ui.elements.adapters.DefaultVariableCellModifier;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class LuaVariableEditor
implements IElementEditor {
    public CellEditor getCellEditor(IPresentationContext context, String columnId, Object element, Composite parent) {
        return new TextCellEditor(parent);
    }

    public ICellModifier getCellModifier(IPresentationContext context, Object element) {
        return new DefaultVariableCellModifier(){

            public Object getValue(Object element, String property) {
                if ("org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_VALUE".equals(property) && element instanceof IVariable) {
                    IVariable variable = (IVariable)element;
                    try {
                        return variable.getValue().getValueString();
                    }
                    catch (DebugException e) {
                        DebugUIPlugin.log((Throwable)e);
                    }
                }
                return null;
            }

            public void modify(Object element, String property, Object value) {
                Object oldValue = this.getValue(element, property);
                if (!value.equals(oldValue) && "org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_VALUE".equals(property) && element instanceof IVariable && value instanceof String) {
                    IVariable variable = (IVariable)element;
                    DetailPaneAssignValueAction.assignValue((Shell)DebugUIPlugin.getShell(), (IVariable)variable, (String)((String)value));
                }
            }
        };
    }
}

