/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.core;

import java.util.ArrayList;

public class SystemTapCommandGenerator {
    private static boolean needsToSendCommand;
    private static boolean needsArguments;
    private static String arguments;
    private static String scriptPath;
    private static String flags;
    private static String binaryPath;
    private static String binaryArguments;
    private static String command;

    static {
        binaryPath = null;
    }

    public static String generateCommand(String scrPath, String binPath, String opts, boolean needBinary, boolean needsArgs, String arg, String binArguments, String cmdTarget) {
        needsToSendCommand = needBinary;
        needsArguments = needsArgs;
        binaryPath = binPath;
        scriptPath = scrPath;
        arguments = "--runtime=dyninst " + arg;
        flags = opts;
        binaryArguments = binArguments;
        command = cmdTarget;
        String[] script = SystemTapCommandGenerator.buildScript();
        String cmd = "";
        int i = 0;
        while (i < script.length - 1) {
            cmd = String.valueOf(cmd) + script[i] + " ";
            ++i;
        }
        cmd = String.valueOf(cmd) + script[script.length - 1];
        return cmd;
    }

    private static String[] buildScript() {
        String[] script;
        ArrayList<String> cmdList = new ArrayList<String>();
        if (flags.length() > 0) {
            cmdList.add(flags);
        }
        if (needsToSendCommand) {
            if (binaryArguments.length() < 1) {
                cmdList.add("-c '" + binaryPath + "'");
            } else {
                cmdList.add("-c \"" + binaryPath + " " + binaryArguments + "\"");
            }
        }
        if (needsArguments) {
            script = new String[cmdList.size() + 3];
            script[script.length - 2] = scriptPath;
            script[script.length - 1] = arguments;
        } else {
            script = new String[cmdList.size() + 2];
            script[script.length - 1] = scriptPath;
        }
        script[0] = command;
        int i = 0;
        while (i < cmdList.size()) {
            script[i + 1] = cmdList.get(i) != null ? (String)cmdList.get(i) : "";
            ++i;
        }
        return script;
    }
}

