/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import com.ibm.icu.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.BooleanQuery;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.index.IndexManager;
import org.eclipse.m2e.core.internal.index.IndexedArtifact;
import org.eclipse.m2e.core.internal.index.IndexedArtifactFile;
import org.eclipse.m2e.core.internal.index.SearchExpression;
import org.eclipse.m2e.core.internal.index.UserInputSearchExpression;
import org.eclipse.m2e.core.internal.index.filter.ArtifactFilterManager;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class MavenPomSelectionComponent
extends Composite {
    public static final String PROP_DECORATION_CONTEXT_PROJECT = "org.eclipse.m2e.core.ui.decorationContextProject";
    Text searchText = null;
    TreeViewer searchResultViewer = null;
    String queryType;
    SearchJob searchJob;
    private IStatus status;
    private ISelectionChangedListener selectionListener;
    public static final String P_SEARCH_INCLUDE_JAVADOC = "searchIncludesJavadoc";
    public static final String P_SEARCH_INCLUDE_SOURCES = "searchIncludesSources";
    public static final String P_SEARCH_INCLUDE_TESTS = "searchIncludesTests";
    private static final long SHORT_DELAY = 150L;
    private static final long LONG_DELAY = 500L;
    final HashSet<String> artifactKeys = new HashSet();
    final HashSet<String> managedKeys = new HashSet();
    private IProject project;

    public void dispose() {
        if (this.searchJob != null) {
            this.searchJob.cancel();
        }
        super.dispose();
    }

    public MavenPomSelectionComponent(Composite parent, int style) {
        super(parent, style);
        this.createSearchComposite();
    }

    private void createSearchComposite() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        Label searchTextlabel = new Label((Composite)this, 0);
        searchTextlabel.setText(Messages.MavenPomSelectionComponent_search_title);
        searchTextlabel.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.searchText = new Text((Composite)this, 2176);
        this.searchText.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.searchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    MavenPomSelectionComponent.this.searchResultViewer.getTree().setFocus();
                    MavenPomSelectionComponent.this.selectFirstElementInTheArtifactTreeIfNoSelectionHasBeenMade();
                }
            }
        });
        this.searchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MavenPomSelectionComponent.this.scheduleSearch(MavenPomSelectionComponent.this.searchText.getText(), true);
            }
        });
        if (!MavenPlugin.getMavenConfiguration().isUpdateIndexesOnStartup()) {
            this.createWarningArea(this);
        }
        Label searchResultsLabel = new Label((Composite)this, 0);
        searchResultsLabel.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        searchResultsLabel.setText(Messages.MavenPomSelectionComponent_lblResults);
        Tree tree = new Tree((Composite)this, 2052);
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        tree.setData("name", (Object)"searchResultTree");
        tree.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                MavenPomSelectionComponent.this.selectFirstElementInTheArtifactTreeIfNoSelectionHasBeenMade();
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.searchResultViewer = new TreeViewer(tree);
    }

    private void createWarningArea(Composite composite) {
        Composite warningArea = new Composite(composite, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).hint(100, -1).applyTo((Control)warningArea);
        warningArea.setLayout((Layout)new GridLayout(2, false));
        Label warningImg = new Label(warningArea, 0);
        GridDataFactory.fillDefaults().align(4, 128).applyTo((Control)warningImg);
        warningImg.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
        Text warningLabel = new Text(warningArea, 74);
        warningLabel.setBackground(composite.getBackground());
        GridDataFactory.fillDefaults().align(16384, 4).grab(true, false).applyTo((Control)warningLabel);
        warningLabel.setText(Messages.MavenPomSelectionComponent_UnavailableRemoteRepositoriesIndexes);
    }

    public boolean setFocus() {
        return this.searchText.setFocus();
    }

    void selectFirstElementInTheArtifactTreeIfNoSelectionHasBeenMade() {
        if (this.searchResultViewer.getTree().getItemCount() > 0 && this.searchResultViewer.getSelection().isEmpty()) {
            Object artifact = this.searchResultViewer.getTree().getTopItem().getData();
            this.searchResultViewer.setSelection((ISelection)new StructuredSelection(artifact), true);
        }
    }

    protected boolean showClassifiers() {
        return this.queryType != null && "artifact".equals(this.queryType);
    }

    public void init(String queryText, String queryType, IProject project, Set<ArtifactKey> artifacts, Set<ArtifactKey> managed) {
        this.queryType = queryType;
        this.project = project;
        if (queryText != null) {
            this.searchText.setText(queryText);
        }
        if (artifacts != null) {
            for (ArtifactKey a : artifacts) {
                this.artifactKeys.add(String.valueOf(a.getGroupId()) + ":" + a.getArtifactId());
                this.artifactKeys.add(String.valueOf(a.getGroupId()) + ":" + a.getArtifactId() + ":" + a.getVersion());
            }
        }
        if (managed != null) {
            for (ArtifactKey a : managed) {
                this.managedKeys.add(String.valueOf(a.getGroupId()) + ":" + a.getArtifactId());
                this.managedKeys.add(String.valueOf(a.getGroupId()) + ":" + a.getArtifactId() + ":" + a.getVersion());
            }
        }
        this.searchResultViewer.setContentProvider((IContentProvider)new SearchResultContentProvider());
        SearchResultLabelProvider labelProvider = new SearchResultLabelProvider(this.artifactKeys, this.managedKeys);
        DecoratingStyledCellLabelProvider decoratingLabelProvider = new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null);
        DecorationContext decorationContext = new DecorationContext();
        if (project != null) {
            decorationContext.putProperty(PROP_DECORATION_CONTEXT_PROJECT, (Object)project);
        }
        decoratingLabelProvider.setDecorationContext((IDecorationContext)decorationContext);
        this.searchResultViewer.setLabelProvider((IBaseLabelProvider)decoratingLabelProvider);
        this.searchResultViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    List<IndexedArtifactFile> files = MavenPomSelectionComponent.this.getSelectedIndexedArtifactFiles(selection);
                    ArtifactFilterManager filterManager = MavenPluginActivator.getDefault().getArifactFilterManager();
                    for (IndexedArtifactFile file : files) {
                        ArtifactKey key = (ArtifactKey)file.getAdapter(ArtifactKey.class);
                        IStatus status = filterManager.filter(MavenPomSelectionComponent.this.project, key);
                        if (status.isOK()) continue;
                        MavenPomSelectionComponent.this.setStatus(4, status.getMessage());
                        return;
                    }
                    if (files.size() == 1) {
                        IndexedArtifactFile f = files.get(0);
                        int severity = 0;
                        String date = DateFormat.getDateTimeInstance((int)2, (int)3).format(f.date);
                        MavenPomSelectionComponent.this.setStatus(severity, NLS.bind((String)Messages.MavenPomSelectionComponent_detail1, (Object)f.fname, (Object)(f.size != -1L ? NLS.bind((String)Messages.MavenPomSelectionComponent_details2, (Object)date, (Object)f.size) : date)));
                    } else {
                        MavenPomSelectionComponent.this.setStatus(0, NLS.bind((String)Messages.MavenPomSelectionComponent_selected, (Object)selection.size()));
                    }
                } else {
                    MavenPomSelectionComponent.this.setStatus(4, Messages.MavenPomSelectionComponent_nosel);
                }
            }
        });
        this.setupClassifiers();
        this.setStatus(4, "");
        this.scheduleSearch(queryText, false);
    }

    protected void setupClassifiers() {
    }

    public IStatus getStatus() {
        return this.status;
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.searchResultViewer.addDoubleClickListener(listener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListener = listener;
    }

    void setStatus(int severity, String message) {
        this.status = new Status(severity, "org.eclipse.m2e.core", 0, message, null);
        if (this.selectionListener != null) {
            this.selectionListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.searchResultViewer, this.searchResultViewer.getSelection()));
        }
    }

    public IndexedArtifact getIndexedArtifact() {
        IStructuredSelection selection = (IStructuredSelection)this.searchResultViewer.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof IndexedArtifact) {
            return (IndexedArtifact)element;
        }
        TreeItem[] treeItems = this.searchResultViewer.getTree().getSelection();
        if (treeItems.length == 0) {
            return null;
        }
        return (IndexedArtifact)treeItems[0].getParentItem().getData();
    }

    public IndexedArtifactFile getIndexedArtifactFile() {
        List<IndexedArtifactFile> files = this.getSelectedIndexedArtifactFiles((IStructuredSelection)this.searchResultViewer.getSelection());
        return !files.isEmpty() ? files.get(0) : null;
    }

    List<IndexedArtifactFile> getSelectedIndexedArtifactFiles(IStructuredSelection selection) {
        ArrayList<IndexedArtifactFile> result = new ArrayList<IndexedArtifactFile>();
        for (Object element : selection.toList()) {
            if (element instanceof IndexedArtifact) {
                IndexedArtifact ia = (IndexedArtifact)element;
                if (this.managedKeys.contains(MavenPomSelectionComponent.getKey(ia))) {
                    for (IndexedArtifactFile file : ia.getFiles()) {
                        if (!this.managedKeys.contains(MavenPomSelectionComponent.getKey(file))) continue;
                        result.add(file);
                    }
                    continue;
                }
                boolean added = false;
                for (IndexedArtifactFile file : ia.getFiles()) {
                    if (file.version == null || file.version.endsWith("-SNAPSHOT")) continue;
                    added = true;
                    result.add(file);
                    break;
                }
                if (added) continue;
                result.add((IndexedArtifactFile)ia.getFiles().iterator().next());
                continue;
            }
            if (!(element instanceof IndexedArtifactFile)) continue;
            result.add((IndexedArtifactFile)element);
        }
        return result;
    }

    void scheduleSearch(String query, boolean delay) {
        if (query != null && query.length() > 2) {
            if (this.searchJob == null) {
                IndexManager indexManager = MavenPlugin.getIndexManager();
                this.searchJob = new SearchJob(this.queryType, indexManager);
            } else if (!this.searchJob.cancel()) {
                IndexManager indexManager = MavenPlugin.getIndexManager();
                this.searchJob = new SearchJob(this.queryType, indexManager);
            }
            this.searchJob.setQuery(query.toLowerCase());
            this.searchJob.schedule(delay ? 500L : 150L);
        } else if (this.searchJob != null) {
            this.searchJob.cancel();
        }
    }

    public static String getKey(IndexedArtifactFile file) {
        return String.valueOf(file.group) + ":" + file.artifact + ":" + file.version;
    }

    public static String getKey(IndexedArtifact art) {
        return String.valueOf(art.getGroupId()) + ":" + art.getArtifactId();
    }

    private class SearchJob
    extends Job {
        private IndexManager indexManager;
        private String query;
        private String field;
        private volatile boolean stop;

        public SearchJob(String field, IndexManager indexManager) {
            super(Messages.MavenPomSelectionComponent_searchJob);
            this.stop = false;
            this.field = field;
            this.indexManager = indexManager;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public boolean shouldRun() {
            this.stop = false;
            return super.shouldRun();
        }

        public int getClassifier() {
            return 9;
        }

        protected IStatus run(IProgressMonitor monitor) {
            int classifier;
            int n = classifier = MavenPomSelectionComponent.this.showClassifiers() ? this.getClassifier() : 15;
            if (MavenPomSelectionComponent.this.searchResultViewer == null || MavenPomSelectionComponent.this.searchResultViewer.getControl() == null || MavenPomSelectionComponent.this.searchResultViewer.getControl().isDisposed()) {
                return Status.CANCEL_STATUS;
            }
            if (this.query != null) {
                String activeQuery = this.query;
                try {
                    this.setResult(0, NLS.bind((String)Messages.MavenPomSelectionComponent_searching, (Object)activeQuery.toLowerCase()), null);
                    Map res = this.indexManager.getAllIndexes().search((SearchExpression)new UserInputSearchExpression(activeQuery), this.field, classifier);
                    LinkedHashMap<String, IndexedArtifact> managed = new LinkedHashMap<String, IndexedArtifact>();
                    LinkedHashMap<String, IndexedArtifact> nonManaged = new LinkedHashMap<String, IndexedArtifact>();
                    for (Map.Entry art : res.entrySet()) {
                        String key = String.valueOf(((IndexedArtifact)art.getValue()).getGroupId()) + ":" + ((IndexedArtifact)art.getValue()).getArtifactId();
                        if (MavenPomSelectionComponent.this.managedKeys.contains(key)) {
                            managed.put((String)art.getKey(), (IndexedArtifact)art.getValue());
                            continue;
                        }
                        nonManaged.put((String)art.getKey(), (IndexedArtifact)art.getValue());
                    }
                    managed.putAll(nonManaged);
                    this.setResult(0, NLS.bind((String)Messages.MavenPomSelectionComponent_results, (Object)activeQuery, (Object)res.size()), managed);
                }
                catch (BooleanQuery.TooManyClauses ex) {
                    this.setResult(4, Messages.MavenPomSelectionComponent_toomany, Collections.emptyMap());
                }
                catch (RuntimeException ex) {
                    this.setResult(4, NLS.bind((String)Messages.MavenPomSelectionComponent_error, (Object)ex.toString()), Collections.emptyMap());
                }
                catch (Exception ex) {
                    this.setResult(4, NLS.bind((String)Messages.MavenPomSelectionComponent_error, (Object)ex.getMessage()), Collections.emptyMap());
                }
            }
            return Status.OK_STATUS;
        }

        protected void canceling() {
            this.stop = true;
        }

        private void setResult(final int severity, final String message, final Map<String, IndexedArtifact> result) {
            if (this.stop) {
                return;
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MavenPomSelectionComponent.this.setStatus(severity, message);
                    if (result != null && !((SearchJob)SearchJob.this).MavenPomSelectionComponent.this.searchResultViewer.getControl().isDisposed()) {
                        ((SearchJob)SearchJob.this).MavenPomSelectionComponent.this.searchResultViewer.setInput((Object)result);
                    }
                }
            });
        }
    }

    public static class SearchResultContentProvider
    implements ITreeContentProvider {
        private static Object[] EMPTY = new Object[0];

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Map) {
                return ((Map)inputElement).values().toArray();
            }
            return EMPTY;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IndexedArtifact) {
                IndexedArtifact a = (IndexedArtifact)parentElement;
                return a.getFiles().toArray();
            }
            return EMPTY;
        }

        public boolean hasChildren(Object element) {
            return element instanceof IndexedArtifact;
        }

        public Object getParent(Object element) {
            return null;
        }

        public void dispose() {
        }
    }

    public static class SearchResultLabelProvider
    extends LabelProvider
    implements IColorProvider,
    DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private final Set<String> artifactKeys;
        private final Set<String> managedKeys;

        public SearchResultLabelProvider(Set<String> artifactKeys, Set<String> managedKeys) {
            this.artifactKeys = artifactKeys;
            this.managedKeys = managedKeys;
        }

        public String getText(Object element) {
            return super.getText(element);
        }

        protected String getRepoDisplayName(String repo) {
            return repo;
        }

        public Color getForeground(Object element) {
            IndexedArtifact i;
            IndexedArtifactFile f;
            if (element instanceof IndexedArtifactFile ? this.artifactKeys.contains(MavenPomSelectionComponent.getKey(f = (IndexedArtifactFile)element)) : element instanceof IndexedArtifact && this.artifactKeys.contains(MavenPomSelectionComponent.getKey(i = (IndexedArtifact)element))) {
                return Display.getDefault().getSystemColor(16);
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof IndexedArtifactFile) {
                IndexedArtifactFile f = (IndexedArtifactFile)element;
                if (this.managedKeys.contains(MavenPomSelectionComponent.getKey(f))) {
                    return MavenImages.getOverlayImage(f.sourcesExists == 1 ? "jar_src_version.gif" : "jar_version.gif", "lock_ovr.gif", 2);
                }
                if (f.sourcesExists == 1) {
                    return MavenImages.IMG_VERSION_SRC;
                }
                return MavenImages.IMG_VERSION;
            }
            if (element instanceof IndexedArtifact) {
                IndexedArtifact i = (IndexedArtifact)element;
                if (this.managedKeys.contains(MavenPomSelectionComponent.getKey(i))) {
                    return MavenImages.getOverlayImage("jar_obj.gif", "lock_ovr.gif", 2);
                }
                return MavenImages.IMG_JAR;
            }
            return null;
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof IndexedArtifact) {
                IndexedArtifact a = (IndexedArtifact)element;
                String name = String.valueOf(a.getClassname() == null ? "" : String.valueOf(a.getClassname()) + "   " + a.getPackageName() + "   ") + a.getGroupId() + "   " + a.getArtifactId();
                StyledString ss = new StyledString();
                ss.append(name);
                if (this.managedKeys.contains(MavenPomSelectionComponent.getKey(a))) {
                    ss.append(Messages.MavenPomSelectionComponent_managed_decoration, StyledString.DECORATIONS_STYLER);
                }
                return ss;
            }
            if (element instanceof IndexedArtifactFile) {
                IndexedArtifactFile f = (IndexedArtifactFile)element;
                StyledString ss = new StyledString();
                String name = String.valueOf(f.version) + " [" + (f.type == null ? "jar" : f.type) + (f.classifier != null ? ", " + f.classifier : "") + "]";
                ss.append(name);
                if (this.managedKeys.contains(MavenPomSelectionComponent.getKey(f))) {
                    ss.append(Messages.MavenPomSelectionComponent_managed_decoration, StyledString.DECORATIONS_STYLER);
                }
                return ss;
            }
            return new StyledString();
        }
    }
}

