/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeCreator {
    private static final Logger log = LoggerFactory.getLogger(ChangeCreator.class);
    private String label;
    private IDocument oldDocument;
    private IDocument newDocument;
    private IFile oldFile;

    public ChangeCreator(IFile oldFile, IDocument oldDocument, IDocument newDocument, String label) {
        this.newDocument = newDocument;
        this.oldDocument = oldDocument;
        this.oldFile = oldFile;
        this.label = label;
    }

    public TextFileChange createChange() throws Exception {
        TextFileChange change = new TextFileChange(this.label, this.oldFile);
        change.setEdit((TextEdit)new MultiTextEdit());
        LineComparator leftSide = new LineComparator(this.oldDocument);
        LineComparator rightSide = new LineComparator(this.newDocument);
        RangeDifference[] differences = RangeDifferencer.findDifferences((IRangeComparator)leftSide, (IRangeComparator)rightSide);
        int insertOffset = 0;
        int i = 0;
        while (i < differences.length) {
            int endLine;
            RangeDifference curr = differences[i];
            int startLine = 0;
            if (curr.rightLength() == curr.leftLength()) {
                startLine = curr.rightStart();
                endLine = curr.rightEnd() - 1;
                int j = startLine;
                while (j <= endLine) {
                    int newPos = curr.leftStart() - startLine + j;
                    String newText = this.newDocument.get(this.newDocument.getLineOffset(newPos), this.newDocument.getLineLength(newPos));
                    this.addEdit(change, startLine, (TextEdit)new ReplaceEdit(this.oldDocument.getLineOffset(j), this.oldDocument.getLineLength(j), newText));
                    ++j;
                }
            } else if (curr.rightLength() > 0 && curr.leftLength() == 0) {
                startLine = curr.rightStart();
                endLine = curr.rightEnd() - 1;
                int posInsert = this.oldDocument.getLineOffset(curr.leftStart());
                String newText = "";
                int j = startLine;
                while (j <= endLine) {
                    int newPos = curr.leftStart() - startLine + j + insertOffset;
                    newText = String.valueOf(newText) + this.newDocument.get(this.newDocument.getLineOffset(newPos), this.newDocument.getLineLength(newPos));
                    ++j;
                }
                if (newText.length() > 0) {
                    this.addEdit(change, startLine, (TextEdit)new InsertEdit(posInsert, newText));
                }
                insertOffset += curr.rightEnd() - curr.rightStart();
            } else if (curr.leftLength() > 0 && curr.rightLength() == 0) {
                startLine = curr.leftStart();
                endLine = curr.leftEnd() - 1;
                int startOffset = this.oldDocument.getLineOffset(startLine);
                int endOffset = 0;
                int j = startLine;
                while (j <= endLine) {
                    endOffset += this.oldDocument.getLineLength(j);
                    ++j;
                }
                this.addEdit(change, startLine, (TextEdit)new DeleteEdit(startOffset, endOffset));
                insertOffset -= curr.leftEnd() - curr.leftStart();
            }
            ++i;
        }
        return change;
    }

    private void addEdit(TextFileChange change, int startLine, TextEdit edit) {
        change.addTextEditGroup(new TextEditGroup("Line " + (startLine + 1), edit));
        change.addEdit(edit);
    }

    public static class LineComparator
    implements IRangeComparator {
        private final IDocument document;
        private final ArrayList<Integer> hashes;

        public LineComparator(IDocument document) {
            this.document = document;
            this.hashes = new ArrayList<Integer>(Arrays.asList(new Integer[document.getNumberOfLines()]));
        }

        public int getRangeCount() {
            return this.document.getNumberOfLines();
        }

        public boolean rangesEqual(int thisIndex, IRangeComparator other, int otherIndex) {
            try {
                return this.getHash(thisIndex).equals(((LineComparator)other).getHash(otherIndex));
            }
            catch (BadLocationException e) {
                log.error("Problem comparing", (Throwable)e);
                return false;
            }
        }

        public boolean skipRangeComparison(int length, int maxLength, IRangeComparator other) {
            return false;
        }

        private Integer getHash(int line) throws BadLocationException {
            Integer hash = this.hashes.get(line);
            if (hash == null) {
                IRegion lineRegion = this.document.getLineInformation(line);
                String lineContents = this.document.get(lineRegion.getOffset(), lineRegion.getLength());
                hash = this.computeDJBHash(lineContents);
                this.hashes.set(line, hash);
            }
            return hash;
        }

        private int computeDJBHash(String string) {
            int hash = 5381;
            int len = string.length();
            int i = 0;
            while (i < len) {
                hash = (hash << 5) + hash + string.charAt(i);
                ++i;
            }
            return hash;
        }
    }
}

