/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.instanceScope.unusedEvaluation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.ocl.ecore.opposites.OppositeEndFinder;
import org.eclipse.ocl.examples.impactanalyzer.ValueNotFoundException;
import org.eclipse.ocl.examples.impactanalyzer.deltaPropagation.VariableValueNotFoundInfo;
import org.eclipse.ocl.examples.impactanalyzer.deltaPropagation.VariableValueNotFoundInfoImpl;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.unusedEvaluation.AbstractUnusedEvaluationRequestValue;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.unusedEvaluation.FindAlwaysUsedVariablesVisitor;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.unusedEvaluation.NoAllInstancesDuringEvaluationForUnusedCheck;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.unusedEvaluation.PartialEvaluatorNoAllInstances;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.unusedEvaluation.UnusedEvaluationRequestFactory;
import org.eclipse.ocl.examples.impactanalyzer.util.OCLFactory;
import org.eclipse.ocl.utilities.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnusedEvaluationRequest {
    private final Map<Variable, Object> inferredVariableValues;
    private final Set<Variable> slots;
    private final OCLExpression expression;
    private final Object resultIndicatingUnused;
    private final SemanticIdentity semanticIdentity;
    private final Set<VariableExp> inevitableVariableUsages;
    public static int evaluations = 0;
    public static int evaluationsAbortedDueToUnknownVariable = 0;
    public static int evaluationsSucceedingAndProvingUnused = 0;
    public static int evaluationsSucceedingWithoutProvingUnused = 0;

    UnusedEvaluationRequest(OCLExpression expression, Object resultIndicatingUnused, Map<Variable, Object> inferredVariableValues, Set<Variable> slots) {
        this(expression, resultIndicatingUnused, inferredVariableValues, slots, (Set)expression.accept((Visitor)new FindAlwaysUsedVariablesVisitor()));
    }

    protected UnusedEvaluationRequest(OCLExpression expression, Object resultIndicatingUnused, Map<Variable, Object> inferredVariableValues, Set<Variable> slots, Set<VariableExp> inevitableVariableUsages) {
        this.expression = expression;
        this.resultIndicatingUnused = resultIndicatingUnused;
        this.inferredVariableValues = inferredVariableValues == null ? Collections.emptyMap() : inferredVariableValues;
        this.slots = slots;
        this.semanticIdentity = new SemanticIdentity();
        this.inevitableVariableUsages = inevitableVariableUsages;
    }

    SemanticIdentity getSemanticIdentity() {
        return this.semanticIdentity;
    }

    UnusedEvaluationRequest getRequestWithSlotsRemoved(Set<Variable> slotsToRemove, UnusedEvaluationRequestFactory unusedEvaluationRequestFactory) {
        UnusedEvaluationRequest result;
        if (slotsToRemove == null || slotsToRemove.isEmpty()) {
            result = this;
        } else {
            Set<Variable> remainingSlots = this.slots;
            for (Variable v : this.slots) {
                if (!slotsToRemove.contains(v)) continue;
                if (remainingSlots == this.slots) {
                    remainingSlots = new HashSet<Variable>(this.slots);
                }
                remainingSlots.remove(v);
            }
            if (remainingSlots != this.slots) {
                HashMap<Variable, Object> remainingInferredVariableValues = new HashMap<Variable, Object>();
                for (Map.Entry<Variable, Object> e : this.inferredVariableValues.entrySet()) {
                    if (slotsToRemove.contains(e.getKey())) continue;
                    remainingInferredVariableValues.put(e.getKey(), e.getValue());
                }
                result = unusedEvaluationRequestFactory.getUnusedEvaluationRequest(this.expression, this.resultIndicatingUnused, remainingInferredVariableValues, remainingSlots, this.inevitableVariableUsages);
            } else {
                result = this;
            }
        }
        return result;
    }

    public boolean hasOneOrMoreSlots() {
        return this.slots != null && this.slots.size() > 0;
    }

    public boolean hasSlotFor(Variable v) {
        return this.slots != null && this.slots.contains(v);
    }

    UnusedEvaluationRequest setInferredVariableValue(Variable variable, Object value, UnusedEvaluationRequestFactory unusedEvaluationRequestFactory) {
        UnusedEvaluationRequest result;
        if (this.slots.contains(variable)) {
            if (this.inferredVariableValues.containsKey(variable)) {
                if (this.inferredVariableValues.get(variable) != value) {
                    throw new RuntimeException("Internal error: inferred two different values for variable " + variable + " in what should have been the same dynamic scope: " + this.inferredVariableValues.get(variable) + " vs. " + value);
                }
                result = this;
            } else {
                HashMap<Variable, Object> newInferredVariableValues = new HashMap<Variable, Object>(this.inferredVariableValues);
                newInferredVariableValues.put(variable, value);
                result = unusedEvaluationRequestFactory.getUnusedEvaluationRequest(this.expression, this.resultIndicatingUnused, newInferredVariableValues, this.slots, this.inevitableVariableUsages);
            }
        } else {
            result = this;
        }
        return result;
    }

    public boolean evaluate(OppositeEndFinder oppositeEndFinder, OCLFactory oclFactory) throws ValueNotFoundException {
        boolean unused;
        Object result;
        PartialEvaluatorNoAllInstances evaluator = this.createPartialEvaluatorNoAllInstances(oppositeEndFinder, oclFactory);
        EvaluationEnvironment env = evaluator.getOcl().getEvaluationEnvironment();
        Object context = null;
        for (Map.Entry<Variable, Object> e : this.inferredVariableValues.entrySet()) {
            if (e.getKey().getName().equals("self")) {
                context = e.getValue();
                continue;
            }
            env.add(e.getKey().getName(), e.getValue());
        }
        try {
            ++evaluations;
            result = evaluator.evaluate(context, this.expression);
        }
        catch (ValueNotFoundException vfne) {
            ++evaluationsAbortedDueToUnknownVariable;
            throw vfne;
        }
        catch (NoAllInstancesDuringEvaluationForUnusedCheck ex) {
            result = ex;
        }
        boolean bl = unused = !(result instanceof NoAllInstancesDuringEvaluationForUnusedCheck) && (result == null && this.resultIndicatingUnused == null || result == evaluator.getOcl().getEnvironment().getOCLStandardLibrary().getInvalid() || result != null && result instanceof Collection && this.resultIndicatingUnused == null && ((Collection)result).isEmpty() || result.equals(this.resultIndicatingUnused));
        if (unused) {
            ++evaluationsSucceedingAndProvingUnused;
        } else {
            ++evaluationsSucceedingWithoutProvingUnused;
        }
        return unused;
    }

    protected PartialEvaluatorNoAllInstances createPartialEvaluatorNoAllInstances(OppositeEndFinder oppositeEndFinder, OCLFactory oclFactory) {
        return new PartialEvaluatorNoAllInstances(oclFactory);
    }

    VariableValueNotFoundInfo checkValuePresentForAllRequiredVariables() {
        for (VariableExp inevitableVariableUse : this.inevitableVariableUsages) {
            if (this.inferredVariableValues.containsKey(inevitableVariableUse.getReferredVariable())) continue;
            return new VariableValueNotFoundInfoImpl(inevitableVariableUse.getReferredVariable().getName(), (org.eclipse.ocl.expressions.VariableExp<EClassifier, EParameter>)inevitableVariableUse);
        }
        return null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[" + this.expression + " = " + this.resultIndicatingUnused + "] with variables [");
        boolean first = true;
        for (Variable slot : this.slots) {
            if (!first) {
                result.append(",");
            } else {
                first = false;
            }
            result.append(slot.getName());
            result.append("=");
            if (this.inferredVariableValues.containsKey(slot)) {
                result.append(this.inferredVariableValues.get(slot));
                continue;
            }
            result.append("?");
        }
        result.append("]");
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SemanticIdentity
    extends AbstractUnusedEvaluationRequestValue {
        protected final int hashCode = this.computeHashCode();

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public Map<Variable, Object> getInferredVariableValues() {
            return UnusedEvaluationRequest.this.inferredVariableValues;
        }

        @Override
        public Set<Variable> getSlots() {
            return UnusedEvaluationRequest.this.slots;
        }

        @Override
        public OCLExpression getExpression() {
            return UnusedEvaluationRequest.this.expression;
        }

        @Override
        public Object getResultIndicatingUnused() {
            return UnusedEvaluationRequest.this.resultIndicatingUnused;
        }
    }
}

