/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.util.swt.internal.imageprovider;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.emf.facet.util.core.DebugUtils;
import org.eclipse.papyrus.emf.facet.util.core.Logger;
import org.eclipse.papyrus.emf.facet.util.swt.imageprovider.IImageProvider;
import org.eclipse.papyrus.emf.facet.util.swt.internal.Activator;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public final class ImageProvider
implements IImageProvider {
    private static final boolean DEBUG = DebugUtils.getDebugStatus((Plugin)Activator.getDefault());
    private final Map<Object, Image> map = new HashMap<Object, Image>();
    private final Plugin activator;

    ImageProvider(Plugin activator) {
        this.activator = activator;
    }

    public ImageDescriptor createImageDescriptor(String resourcePath) {
        ImageDescriptor result;
        URL url = this.activator.getBundle().getResource(resourcePath);
        if (url == null) {
            Logger.logError((String)NLS.bind((String)"Resource not found: {0}", (Object)resourcePath), (Plugin)this.activator);
            result = ImageDescriptor.getMissingImageDescriptor();
        } else {
            result = ImageDescriptor.createFromURL((URL)url);
        }
        return result;
    }

    public Image getImage(String path) {
        Image result = this.map.get(path);
        if (result == null) {
            result = this.createImageDescriptor(path).createImage();
            this.map.put(path, result);
            if (DEBUG) {
                Bundle bundle = this.activator.getBundle();
                String bundleId = bundle.getSymbolicName();
                String message = String.format("New image loaded: %s:%s", bundleId, path);
                DebugUtils.debug((String)message);
            }
        }
        return result;
    }

    public Image getImage(ImageDescriptor imgDescriptor) {
        Image result = this.map.get(imgDescriptor);
        if (result == null) {
            result = imgDescriptor.createImage();
            this.map.put(imgDescriptor, result);
            if (DEBUG) {
                Bundle bundle = this.activator.getBundle();
                String bundleId = bundle.getSymbolicName();
                String message = String.format("New image loaded from an image descriptor (bundle=%s)", bundleId);
                DebugUtils.debug((String)message);
            }
        }
        return result;
    }
}

