/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.resource.EMFLogicalModel;

public abstract class AbstractModelWithSharedResource<T extends EObject>
extends EMFLogicalModel {
    protected ModelKind modelKind;

    public AbstractModelWithSharedResource(ModelKind modelKind) {
        this.modelKind = modelKind;
    }

    public AbstractModelWithSharedResource() {
        this.modelKind = ModelKind.slave;
    }

    @Override
    public void loadModel(URI uriWithoutExtension) {
        block3: {
            try {
                this.lookupResource(uriWithoutExtension);
                if (this.resourceIsSet()) {
                    this.configureResource(this.resource);
                    this.startSnippets();
                    return;
                }
                super.loadModel(uriWithoutExtension);
            }
            catch (Exception ex) {
                if (this.modelKind != ModelKind.master) break block3;
                Activator.log.error((Throwable)ex);
            }
        }
    }

    @Override
    public void createModel(URI uri) {
        block3: {
            try {
                this.lookupResource(uri);
                if (this.resourceIsSet()) {
                    this.configureResource(this.resource);
                    return;
                }
                super.createModel(uri);
            }
            catch (Exception ex) {
                if (this.modelKind != ModelKind.master) break block3;
                Activator.log.error((Throwable)ex);
            }
        }
    }

    private void lookupResource(URI uriWithoutExtension) {
        this.resourceURI = uriWithoutExtension.appendFileExtension(this.getModelFileExtension());
        this.resource = this.getResourceSet().getResource(this.resourceURI, false);
    }

    @Override
    public void saveModel() throws IOException {
        if (this.modelKind == ModelKind.slave) {
            return;
        }
        super.saveModel();
    }

    @Override
    public void saveCopy(IPath targetPathWithoutExtension, Map<Object, Object> targetMap) {
        if (this.modelKind == ModelKind.slave) {
            return;
        }
        super.saveCopy(targetPathWithoutExtension, targetMap);
    }

    public T getModelRoot() {
        Resource resource = this.getResource();
        if (resource == null) {
            return null;
        }
        for (EObject object : resource.getContents()) {
            if (!this.isModelRoot(object)) continue;
            return (T)object;
        }
        return null;
    }

    public List<T> getModelRoots() {
        ArrayList<EObject> roots = new ArrayList<EObject>();
        for (EObject object : this.getResource().getContents()) {
            if (!this.isModelRoot(object)) continue;
            roots.add(object);
        }
        return roots;
    }

    @Override
    public Iterable<? extends EObject> getRootElements() {
        return this.getModelRoots();
    }

    @Override
    public boolean isModelFor(Object element) {
        if (this.modelKind == ModelKind.slave) {
            return false;
        }
        return super.isModelFor(element);
    }

    protected abstract boolean isModelRoot(EObject var1);

    public void addModelRoot(T root) {
        this.getResource().getContents().add(root);
    }

    @Override
    protected Map<Object, Object> getSaveOptions() {
        if (this.modelKind == ModelKind.master) {
            return super.getSaveOptions();
        }
        return Collections.emptyMap();
    }

    @Override
    protected boolean isSupportedRoot(EObject object) {
        return this.isModelRoot(object);
    }

    public static enum ModelKind {
        master,
        slave;

    }
}

