/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.editor.welcome.internal.modelelements;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.emf.common.command.Command;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModel;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModelUtils;
import org.eclipse.papyrus.infra.editor.welcome.internal.modelelements.AbstractPageLayoutToggleValue;
import org.eclipse.papyrus.infra.editor.welcome.internal.modelelements.WelcomeModelElement;
import org.eclipse.papyrus.infra.ui.internal.commands.SashLayoutCommandFactory;

public class PrivateLayoutValue
extends AbstractPageLayoutToggleValue
implements PropertyChangeListener {
    private SashModel sashModel;

    public PrivateLayoutValue(WelcomeModelElement owner) {
        this(Realm.getDefault(), owner);
    }

    public PrivateLayoutValue(Realm realm, WelcomeModelElement owner) {
        super(realm, owner);
        this.sashModel = SashModelUtils.getSashModel((ModelSet)((ModelSet)owner.getDomain().getResourceSet()));
        if (this.sashModel != null) {
            this.sashModel.addPropertyChangeListener("legacyMode", (PropertyChangeListener)this);
        }
    }

    public synchronized void dispose() {
        if (this.sashModel != null) {
            this.sashModel.removePropertyChangeListener("legacyMode", (PropertyChangeListener)this);
            this.sashModel = null;
        }
        super.dispose();
    }

    protected Boolean doGetValue() {
        return !this.sashModel.isLegacyMode();
    }

    @Override
    protected Command getToggleCommand(SashLayoutCommandFactory factory) {
        return factory.createTogglePrivateLayoutCommand();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        block7: {
            if (evt.getSource() != this.sashModel) break block7;
            switch (evt.getPropertyName()) {
                case "legacyMode": {
                    this.fireValueChange(Diffs.createValueDiff((Object)((Boolean)evt.getOldValue() == false ? 1 : 0), (Object)((Boolean)evt.getNewValue() == false ? 1 : 0)));
                }
            }
        }
    }
}

