/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.jaxb.control.core.variables;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.ems.core.EnvManagerConfigString;
import org.eclipse.ptp.ems.core.IEnvManagerConfig;
import org.eclipse.ptp.internal.rm.jaxb.control.core.messages.Messages;
import org.eclipse.ptp.internal.rm.jaxb.control.core.variables.RMVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;

public class RMVariableResolver
implements IDynamicVariableResolver {
    private static RMVariableMap fActive;

    private static String invokeGetter(Object target, String string) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String name = "get" + string.substring(0, 1).toUpperCase() + string.substring(1);
        Method getter = target.getClass().getDeclaredMethod(name, null);
        Object result = getter.invoke(target, null);
        if (result == null) {
            return null;
        }
        return String.valueOf(result);
    }

    public static void setActive(RMVariableMap active) {
        fActive = active;
    }

    private String resolveEMS(String value) {
        if (!value.equals("") && EnvManagerConfigString.isEnvMgmtConfigString((String)value)) {
            if (fActive.getEnvManager() != null) {
                return fActive.getEnvManager().getBashConcatenation("\n", false, (IEnvManagerConfig)new EnvManagerConfigString(value), null);
            }
            return "";
        }
        return value;
    }

    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        String[] parts;
        AttributeType value;
        if (fActive != null && argument != null && (value = fActive.get((parts = argument.split("[#]"))[0])) != null) {
            if (parts.length == 2) {
                String result;
                try {
                    result = RMVariableResolver.invokeGetter(value, parts[1]);
                }
                catch (Throwable t) {
                    throw CoreExceptionUtils.newException((String)Messages.RMVariableResolver_derefError, (Throwable)t);
                }
                if (result != null) {
                    return this.resolveEMS(result);
                }
                return result;
            }
            return this.resolveEMS(String.valueOf(value));
        }
        return null;
    }
}

