/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class WidgetResolver {
    private static final Logger log = Logger.getLogger(WidgetResolver.class);
    private static WidgetResolver instance = null;
    private static final Class<?>[] supported = new Class[]{ExpandBar.class, ExpandItem.class, CTabFolder.class, TabFolder.class, CTabItem.class, TabItem.class, ToolBar.class, Composite.class, Control.class};

    private WidgetResolver() {
    }

    public static WidgetResolver getInstance() {
        if (instance == null) {
            instance = new WidgetResolver();
        }
        return instance;
    }

    public Widget getParent(Widget w) {
        if (w instanceof ExpandBar) {
            return ((ExpandBar)w).getParent();
        }
        if (w instanceof ExpandItem) {
            return ((ExpandItem)w).getParent();
        }
        if (w instanceof CTabFolder) {
            return ((CTabFolder)w).getParent();
        }
        if (w instanceof TabFolder) {
            return ((TabFolder)w).getParent();
        }
        if (w instanceof CTabItem) {
            return ((CTabItem)w).getParent();
        }
        if (w instanceof TabItem) {
            return ((TabItem)w).getParent();
        }
        if (w instanceof ToolBar) {
            return ((ToolBar)w).getParent();
        }
        if (w instanceof ToolItem) {
            return ((ToolItem)w).getParent();
        }
        if (w instanceof TableItem) {
            return ((TableItem)w).getParent();
        }
        if (w instanceof Composite) {
            Composite parent = ((Composite)w).getParent();
            if (parent instanceof TabFolder) {
                if (parent == null || parent.isDisposed()) {
                    throw new CoreLayerException("TabFolder is null or disposed while resolving");
                }
                TabItem[] tabItems = ((TabFolder)parent).getItems();
                int index = Arrays.asList(tabItems).indexOf(w);
                if (index == -1) {
                    throw new CoreLayerException("Widget not found under TabFolder");
                }
                return tabItems[index];
            }
            return parent;
        }
        if (w instanceof Control) {
            return ((Control)w).getParent();
        }
        log.warn("Cannot find parent of widget. Widget type is not supported (" + w.getClass() + ")");
        return null;
    }

    public List<Widget> getChildren(Widget w) {
        List<Object> children = new ArrayList();
        if (w instanceof ExpandBar) {
            ExpandItem[] items = ((ExpandBar)w).getItems();
            children = Arrays.asList(items);
        } else if (w instanceof ExpandItem) {
            Control control = ((ExpandItem)w).getControl();
            if (control != null) {
                children.add((Widget)control);
            }
        } else if (w instanceof CTabFolder) {
            ArrayList<Object> tempList = new ArrayList<Object>();
            tempList.addAll(Arrays.asList(((CTabFolder)w).getChildren()));
            tempList.addAll(Arrays.asList(((CTabFolder)w).getItems()));
            children = tempList;
        } else if (w instanceof TabFolder) {
            TabItem[] items = ((TabFolder)w).getItems();
            children = Arrays.asList(items);
        } else if (w instanceof CTabItem) {
            Control control = ((CTabItem)w).getControl();
            if (control != null) {
                children.add(control);
            }
        } else if (w instanceof TabItem) {
            Control control = ((TabItem)w).getControl();
            if (control != null) {
                children.add(control);
            }
        } else if (w instanceof ToolBar) {
            ToolItem[] items = ((ToolBar)w).getItems();
            children = Arrays.asList(items);
        } else if (!(w instanceof ToolItem)) {
            if (w instanceof Table) {
                ArrayList<Object> tempList = new ArrayList<Object>();
                tempList.addAll(Arrays.asList(((Table)w).getChildren()));
                tempList.addAll(Arrays.asList(((Table)w).getItems()));
                children = tempList;
            } else if (!(w instanceof TableItem)) {
                if (w instanceof Composite) {
                    Control[] items = ((Composite)w).getChildren();
                    children = Arrays.asList(items);
                } else if (!(w instanceof Control)) {
                    log.warn("Cannot find children of widget. Widget type is not supported (" + w.getClass() + ")");
                }
            }
        }
        return children;
    }

    public boolean hasParent(Widget w) {
        return this.getParent(w) != null;
    }

    public boolean hasChildren(Widget w) {
        return this.isResolvable(w) && this.getChildren(w).size() > 0;
    }

    public boolean isResolvable(Widget w) {
        if (w instanceof DateTime) {
            return false;
        }
        return Arrays.asList(supported).contains(w.getClass());
    }
}

