/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.scout.sdk.core.s.util.maven.IMavenRunnerSpi;
import org.eclipse.scout.sdk.core.s.util.maven.MavenBuild;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.ScoutSdkCore;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.scout.sdk.s2e.util.ScoutStatus;

public class MavenBuildOperation
implements IOperation {
    public static final String LAUNCH_CONFIGURATION_TYPE_ID = "org.eclipse.m2e.Maven2LaunchConfigurationType";
    public static final String WORKING_DIRECTORY = "org.eclipse.jdt.launching.WORKING_DIRECTORY";
    public static final String JRE_CONTAINER = "org.eclipse.jdt.launching.JRE_CONTAINER";
    public static final String M2_PROFILES = "M2_PROFILES";
    public static final String M2_GOALS = "M2_GOALS";
    public static final String M2_PROPERTIES = "M2_PROPERTIES";
    public static final String M2_OFFLINE = "M2_OFFLINE";
    public static final String M2_UPDATE_SNAPSHOTS = "M2_UPDATE_SNAPSHOTS";
    public static final String M2_SKIP_TESTS = "M2_SKIP_TESTS";
    public static final String M2_NON_RECURSIVE = "M2_NON_RECURSIVE";
    public static final String M2_WORKSPACE_RESOLUTION = "M2_WORKSPACE_RESOLUTION";
    public static final String M2_DEBUG_OUTPUT = "M2_DEBUG_OUTPUT";
    public static final String M2_THREADS = "M2_THREADS";
    public static final String M2_SKIP_TEST = "maven.test.skip";
    private static final AtomicLong BUILD_NAME_NUM = new AtomicLong(0L);
    private MavenBuild m_build;
    private CountDownLatch m_artifactGenCompleted;
    private boolean m_waitUntilCompleted = true;
    private final List<Integer> m_mavenReturnCodes = new ArrayList<Integer>(1);

    @Override
    public String getOperationName() {
        return "Maven Build";
    }

    @Override
    public void validate() {
        Validate.notNull((Object)this.getBuild());
        Validate.isTrue((!this.getBuild().getGoals().isEmpty() ? 1 : 0) != 0);
        Validate.notNull((Object)this.getBuild().getWorkingDirectory());
    }

    @Override
    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getOperationName(), (int)10);
        this.m_artifactGenCompleted = new CountDownLatch(1);
        this.scheduleMavenBuild(progress);
        if (progress.isCanceled()) {
            return;
        }
        if (this.isWaitUntilCompleted()) {
            progress.setTaskName("Wait for Maven build...");
            this.waitForArtifactBuildCompleted();
            for (Integer mavenReturnCode : this.m_mavenReturnCodes) {
                if (mavenReturnCode != null && mavenReturnCode == 0) continue;
                throw new CoreException((IStatus)new ScoutStatus("Maven build failed with error code " + mavenReturnCode + ". See Maven Console for details."));
            }
        }
        progress.worked(4);
    }

    protected void scheduleMavenBuild(SubMonitor progress) throws CoreException {
        final DebugPlugin debugPlugin = DebugPlugin.getDefault();
        final ILaunchManager launchManager = debugPlugin.getLaunchManager();
        final HashSet watchedProcesses = new HashSet(1);
        ILaunchConfiguration launchConfiguration = this.createLaunchConfiguration((IProgressMonitor)progress.newChild(1));
        final IDebugEventSetListener eventSetListener = new IDebugEventSetListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleDebugEvents(DebugEvent[] events) {
                Set set = watchedProcesses;
                synchronized (set) {
                    DebugEvent[] debugEventArray = events;
                    int n = events.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProcess changedProcess;
                        DebugEvent e = debugEventArray[n2];
                        Object source = e.getSource();
                        if (source != null && watchedProcesses.contains(source) && (changedProcess = (IProcess)source).isTerminated()) {
                            int exitValue = -1;
                            try {
                                exitValue = changedProcess.getExitValue();
                            }
                            catch (DebugException ex) {
                                SdkLog.error((String)"Error reading exit value.", (Object[])new Object[]{ex});
                            }
                            MavenBuildOperation.this.m_mavenReturnCodes.add(exitValue);
                            watchedProcesses.remove(changedProcess);
                        }
                        ++n2;
                    }
                    if (watchedProcesses.isEmpty()) {
                        debugPlugin.removeDebugEventListener((IDebugEventSetListener)this);
                        MavenBuildOperation.this.m_artifactGenCompleted.countDown();
                    }
                }
            }
        };
        ILaunchListener launchListener = new ILaunchListener(){

            public void launchRemoved(ILaunch launch) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void launchChanged(ILaunch launch) {
                IProcess[] processes = launch.getProcesses();
                if (processes == null || processes.length < 1) {
                    return;
                }
                Set set = watchedProcesses;
                synchronized (set) {
                    debugPlugin.addDebugEventListener(eventSetListener);
                    IProcess[] iProcessArray = processes;
                    int n = processes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProcess p = iProcessArray[n2];
                        watchedProcesses.add(p);
                        ++n2;
                    }
                    launchManager.removeLaunchListener((ILaunchListener)this);
                }
            }

            public void launchAdded(ILaunch launch) {
            }
        };
        launchManager.addLaunchListener(launchListener);
        SdkLog.debug((String)"Executing embedded {}", (Object[])new Object[]{this.getBuild().toString()});
        launchConfiguration.launch("run", (IProgressMonitor)progress.newChild(5), false, true);
    }

    protected void waitForArtifactBuildCompleted() {
        try {
            this.m_artifactGenCompleted.await(5L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            SdkLog.debug((Object[])new Object[]{e});
        }
    }

    protected IContainer getWorkspaceContainer() {
        IContainer[] containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(this.getBuild().getWorkingDirectory().toURI());
        if (containers.length < 1) {
            return null;
        }
        return containers[0];
    }

    protected ILaunchConfiguration createLaunchConfiguration(IProgressMonitor monitor) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType(LAUNCH_CONFIGURATION_TYPE_ID);
        ILaunchConfigurationWorkingCopy workingCopy = launchConfigurationType.newInstance(null, "-mavenBuild" + BUILD_NAME_NUM.getAndIncrement());
        workingCopy.setAttribute(WORKING_DIRECTORY, this.getBuild().getWorkingDirectory().getAbsolutePath());
        workingCopy.setAttribute("org.eclipse.debug.ui.private", true);
        workingCopy.setAttribute(M2_UPDATE_SNAPSHOTS, this.getBuild().hasOption('U'));
        workingCopy.setAttribute(M2_OFFLINE, this.getBuild().hasOption('o'));
        workingCopy.setAttribute(M2_SKIP_TESTS, this.getBuild().getProperties().containsKey(M2_SKIP_TEST));
        workingCopy.setAttribute(M2_NON_RECURSIVE, this.getBuild().hasOption('N'));
        workingCopy.setAttribute(M2_WORKSPACE_RESOLUTION, true);
        workingCopy.setAttribute(M2_DEBUG_OUTPUT, SdkLog.isDebugEnabled() || this.getBuild().hasOption('X'));
        workingCopy.setAttribute(M2_THREADS, 1);
        workingCopy.setAttribute(M2_PROPERTIES, this.getBuild().getPropertiesAsList());
        MavenBuildOperation.setGoals(workingCopy, this.getBuild().getGoals());
        IContainer container = this.getWorkspaceContainer();
        MavenBuildOperation.setProjectConfiguration(workingCopy, container, monitor);
        MavenBuildOperation.setJreContainerPath(workingCopy, container);
        return workingCopy;
    }

    protected static void setJreContainerPath(ILaunchConfigurationWorkingCopy workingCopy, IContainer container) throws CoreException {
        IPath path = MavenBuildOperation.getJreContainerPath(container);
        if (path != null) {
            workingCopy.setAttribute(JRE_CONTAINER, path.toPortableString());
        }
    }

    protected static void setGoals(ILaunchConfigurationWorkingCopy workingCopy, Set<String> goals) {
        StringBuilder goalBuilder = new StringBuilder();
        Iterator<String> iterator = goals.iterator();
        goalBuilder.append(iterator.next());
        while (iterator.hasNext()) {
            goalBuilder.append(' ').append(iterator.next());
        }
        workingCopy.setAttribute(M2_GOALS, goalBuilder.toString());
    }

    protected static void setProjectConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IContainer basedir, IProgressMonitor monitor) {
        if (basedir == null || !basedir.exists() || basedir.getType() != 4) {
            return;
        }
        IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
        if (projectManager == null) {
            return;
        }
        IFile pomFile = basedir.getFile((IPath)new Path("pom.xml"));
        IMavenProjectFacade projectFacade = projectManager.create(pomFile, false, monitor);
        if (projectFacade == null) {
            return;
        }
        ResolverConfiguration configuration = projectFacade.getResolverConfiguration();
        if (configuration == null) {
            return;
        }
        String selectedProfiles = configuration.getSelectedProfiles();
        if (StringUtils.isNotBlank((CharSequence)selectedProfiles)) {
            workingCopy.setAttribute(M2_PROFILES, selectedProfiles);
        }
    }

    protected static IPath getJreContainerPath(IContainer basedir) throws CoreException {
        if (basedir == null || !basedir.exists()) {
            return null;
        }
        IProject project = basedir.getProject();
        if (project == null || !project.hasNature("org.eclipse.jdt.core.javanature")) {
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (!S2eUtils.exists((IJavaElement)javaProject)) {
            return null;
        }
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (JRE_CONTAINER.equals(entry.getPath().segment(0))) {
                return entry.getPath();
            }
            ++i;
        }
        return null;
    }

    public boolean isWaitUntilCompleted() {
        return this.m_waitUntilCompleted;
    }

    public void setWaitUntilCompleted(boolean waitUntilCompleted) {
        this.m_waitUntilCompleted = waitUntilCompleted;
    }

    public MavenBuild getBuild() {
        return this.m_build;
    }

    public void setBuild(MavenBuild build) {
        this.m_build = build;
    }

    public static final class M2eMavenRunner
    implements IMavenRunnerSpi {
        public void execute(MavenBuild build) {
            MavenBuildOperation op = new MavenBuildOperation();
            op.setBuild(build);
            op.validate();
            try {
                op.run((IProgressMonitor)new NullProgressMonitor(), ScoutSdkCore.createWorkingCopyManager());
            }
            catch (CoreException e) {
                throw new SdkException((Throwable)e);
            }
        }
    }
}

