/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.helper.delete;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.sirius.business.api.delete.IDeleteHook;
import org.eclipse.sirius.business.internal.helper.delete.IDeleteHookDescriptor;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class EclipseDeleteHookDescriptor
implements IDeleteHookDescriptor {
    private final String id;
    private final IConfigurationElement element;
    private IDeleteHook extension;

    public EclipseDeleteHookDescriptor(IConfigurationElement configuration) {
        this.id = configuration.getAttribute("id");
        this.element = configuration;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IDeleteHook getIDeleteHook() {
        if (this.extension == null && Platform.isRunning()) {
            try {
                this.extension = (IDeleteHook)this.element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                SiriusPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.sirius", MessageFormat.format(Messages.EclipseDeleteHookDescriptor_extensionLoadingErrorMsg, this.element.getDeclaringExtension().getUniqueIdentifier()), (Throwable)e));
            }
        }
        return this.extension;
    }
}

