/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.theme;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ColorMap {
    private int _lastColorId = 0;
    private final Map<String, Integer> _color2id = new HashMap<String, Integer>();

    public int getId(String color) {
        if (color == null) {
            return 0;
        }
        Integer value = this._color2id.get(color = color.toUpperCase());
        if (value != null) {
            return value;
        }
        value = ++this._lastColorId;
        this._color2id.put(color, value);
        return value;
    }

    public String getColor(int id) {
        for (Map.Entry<String, Integer> entry : this._color2id.entrySet()) {
            if (id != entry.getValue()) continue;
            return entry.getKey();
        }
        return null;
    }

    public Set<String> getColorMap() {
        return this._color2id.keySet();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this._color2id == null ? 0 : this._color2id.hashCode());
        result = 31 * result + this._lastColorId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColorMap other = (ColorMap)obj;
        if (this._color2id == null ? other._color2id != null : !this._color2id.equals(other._color2id)) {
            return false;
        }
        return this._lastColorId == other._lastColorId;
    }
}

