/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.migrator.metadata;

import javax.inject.Inject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.query.tooling.ui.migrator.metadata.NatureUpdaterJob;
import org.eclipse.xtext.builder.EclipseOutputConfigurationProvider;

public class ProjectNatureUpdater
extends AbstractHandler {
    @Inject
    private EclipseOutputConfigurationProvider outputConfigurationProvider;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection) {
            for (Object element : ((IStructuredSelection)currentSelection).toList()) {
                IProject project = null;
                if (element instanceof IProject) {
                    project = (IProject)element;
                } else if (element instanceof IAdaptable) {
                    project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
                }
                if (project == null) continue;
                NatureUpdaterJob job = new NatureUpdaterJob(project, this.outputConfigurationProvider);
                job.schedule();
                try {
                    ICommandService service = (ICommandService)HandlerUtil.getActiveSite((ExecutionEvent)event).getService(ICommandService.class);
                    service.getCommand("org.eclipse.viatra.query.tooling.migrator.api.command").executeWithChecks(event);
                }
                catch (NotEnabledException | NotHandledException | NotDefinedException e) {
                    throw new ExecutionException("Error migrating project", e);
                }
            }
        }
        return null;
    }
}

