/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network.communication;

import java.util.Collection;
import java.util.Map;
import org.eclipse.viatra.query.runtime.rete.network.Node;
import org.eclipse.viatra.query.runtime.rete.network.RederivableNode;
import org.eclipse.viatra.query.runtime.rete.network.communication.CommunicationTracker;
import org.eclipse.viatra.query.runtime.rete.network.communication.MessageSelector;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;

public abstract class CommunicationGroup
implements Comparable<CommunicationGroup> {
    public static final String UNSUPPORTED_MESSAGE_KIND = "Unsupported message kind ";
    public boolean isEnqueued = false;
    protected final Node representative;
    protected int identifier;
    protected final CommunicationTracker tracker;

    public CommunicationGroup(CommunicationTracker tracker, Node representative, int identifier) {
        this.tracker = tracker;
        this.representative = representative;
        this.identifier = identifier;
    }

    public abstract void deliverMessages();

    public Node getRepresentative() {
        return this.representative;
    }

    public abstract boolean isEmpty();

    public abstract void notifyLostAllMessages(Mailbox var1, MessageSelector var2);

    public abstract void notifyHasMessage(Mailbox var1, MessageSelector var2);

    public abstract void addRederivable(RederivableNode var1);

    public abstract void removeRederivable(RederivableNode var1);

    public abstract Map<MessageSelector, Collection<Mailbox>> getMailboxes();

    public abstract Collection<RederivableNode> getRederivables();

    public abstract boolean isRecursive();

    public int hashCode() {
        return this.identifier;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.identifier + " - representative: " + this.representative + " - isEmpty: " + this.isEmpty();
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        CommunicationGroup that = (CommunicationGroup)obj;
        return this.identifier == that.identifier;
    }

    @Override
    public int compareTo(CommunicationGroup that) {
        return this.identifier - that.identifier;
    }
}

