/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.ui.property;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.wb.internal.core.databinding.model.IBindingInfo;
import org.eclipse.wb.internal.core.databinding.ui.property.AbstractBindingProperty;
import org.eclipse.wb.internal.core.databinding.ui.property.AbstractObserveProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.TextDialogPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.complex.IComplexPropertyEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObservePropertyEditor
extends TextDialogPropertyEditor
implements IComplexPropertyEditor {
    public static final ObservePropertyEditor EDITOR = new ObservePropertyEditor();

    public List<AbstractBindingProperty> updateProperties(Property property) throws Exception {
        List<AbstractBindingProperty> bindingProperties;
        block4: {
            int i;
            int newSize;
            int oldSize;
            ArrayList isTargets;
            ArrayList bindings;
            AbstractObserveProperty observeProperty;
            block3: {
                observeProperty = (AbstractObserveProperty)property;
                bindingProperties = observeProperty.getBindingProperties();
                bindings = Lists.newArrayList();
                isTargets = Lists.newArrayList();
                observeProperty.getBindings(bindings, isTargets);
                oldSize = bindingProperties.size();
                newSize = bindings.size();
                int size = Math.min(oldSize, newSize);
                i = 0;
                while (i < size) {
                    bindingProperties.get(i).setBinding((IBindingInfo)bindings.get(i), (Boolean)isTargets.get(i));
                    ++i;
                }
                if (oldSize <= newSize) break block3;
                i = newSize;
                while (i < oldSize) {
                    bindingProperties.remove(newSize);
                    ++i;
                }
                break block4;
            }
            if (oldSize >= newSize) break block4;
            i = oldSize;
            while (i < newSize) {
                AbstractBindingProperty bindingProperty = observeProperty.createBindingProperty();
                bindingProperty.setBinding((IBindingInfo)bindings.get(i), (Boolean)isTargets.get(i));
                bindingProperties.add(bindingProperty);
                ++i;
            }
        }
        return bindingProperties;
    }

    public Property[] getProperties(Property property) throws Exception {
        List<AbstractBindingProperty> properties = this.updateProperties(property);
        return properties.toArray(new Property[properties.size()]);
    }

    protected String getText(Property property) throws Exception {
        StringBuffer text = new StringBuffer();
        for (AbstractBindingProperty bindingProperty : this.updateProperties(property)) {
            if (text.length() > 0) {
                text.append(", ");
            }
            text.append(bindingProperty.getText());
        }
        if (text.length() > 0) {
            text.insert(0, "[");
            text.append("]");
        }
        return text.toString();
    }

    protected void openDialog(Property property) throws Exception {
        AbstractObserveProperty observeProperty = (AbstractObserveProperty)property;
        observeProperty.createBinding();
    }
}

