/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.palette.dialogs;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.editor.palette.model.PaletteInfo;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.editor.palette.command.CategoryAddCommand;
import org.eclipse.wb.internal.core.editor.palette.command.Command;
import org.eclipse.wb.internal.core.editor.palette.dialogs.CategoryAbstractDialog;
import org.eclipse.wb.internal.core.utils.dialogfields.ComboDialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogField;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;

public final class CategoryAddDialog
extends CategoryAbstractDialog {
    private final PaletteInfo m_palette;
    private final CategoryInfo m_initialNextCategory;
    private ComboDialogField m_locationField;

    public CategoryAddDialog(Shell parentShell, PaletteInfo palette, CategoryInfo initialNextCategory) {
        super(parentShell, Messages.CategoryAddDialog_title, Messages.CategoryAddDialog_message);
        this.m_palette = palette;
        this.m_initialNextCategory = initialNextCategory;
    }

    protected void createAdditionalControls(Composite container) {
        this.m_stateField.setSelection(0, true);
        this.m_stateField.setSelection(1, true);
        String id = "custom_" + System.currentTimeMillis();
        this.m_idField.setTextWithoutUpdate(id);
        this.m_locationField = new ComboDialogField(8);
        this.doCreateField((DialogField)this.m_locationField, Messages.CategoryAddDialog_targetCategoryLabel);
        boolean categorySelected = false;
        for (CategoryInfo category : this.m_palette.getCategories()) {
            this.m_locationField.addItem(MessageFormat.format(Messages.CategoryAddDialog_targetCategoryBefore, category.getName()));
            if (category != this.m_initialNextCategory) continue;
            this.m_locationField.selectItem(this.m_locationField.getItemCount() - 1);
            categorySelected = true;
        }
        this.m_locationField.addItem(Messages.CategoryAddDialog_targetCategoryEnd);
        if (!categorySelected) {
            this.m_locationField.selectItem(this.m_locationField.getItemCount() - 1);
        }
        UiUtils.setVisibleItemCount((Combo)this.m_locationField.getComboControl(null), (int)this.m_locationField.getItemCount());
    }

    protected Command createCommand() {
        List<CategoryInfo> categories;
        String id = this.m_idField.getText();
        String name = this.m_nameField.getText();
        String description = this.m_descriptionField.getText();
        boolean hidden = this.m_stateField.isSelected(0);
        boolean open = this.m_stateField.isSelected(1);
        String nextCategoryId = null;
        int index = this.m_locationField.getSelectionIndex();
        if (index < (categories = this.m_palette.getCategories()).size()) {
            nextCategoryId = categories.get(index).getId();
        }
        return new CategoryAddCommand(id, name, description, hidden, open, nextCategoryId);
    }
}

