/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.launcher;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;
import org.eclipse.wst.jsdt.chromium.debug.core.model.LaunchParams;

abstract class TabBase<ELEMENTS, PARAMS>
extends AbstractLaunchConfigurationTab {
    private final PARAMS params;
    private ELEMENTS tabElements = null;

    protected TabBase(PARAMS params) {
        this.params = params;
    }

    protected PARAMS getParams() {
        return this.params;
    }

    public void createControl(Composite parent) {
        Runnable modifyListener = new Runnable(){

            @Override
            public void run() {
                TabBase.this.updateLaunchConfigurationDialog();
            }
        };
        this.tabElements = this.createElements(parent, modifyListener);
    }

    protected abstract ELEMENTS createElements(Composite var1, Runnable var2);

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.getTabFields().setDefaults(configuration, this.getParams());
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.getTabFields().initializeFrom(this.tabElements, configuration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.getTabFields().saveToConfig(this.tabElements, configuration);
    }

    public boolean isValid(ILaunchConfiguration config) {
        MessageData messageData;
        try {
            messageData = this.isValidImpl(config);
        }
        catch (CoreException e) {
            ChromiumDebugPlugin.log((Throwable)new Exception("Unexpected storage problem", e));
            messageData = new MessageData(true, "Internal error " + e.getMessage());
        }
        if (messageData == null) {
            messageData = MessageData.EMPTY_OK;
        }
        if (messageData.isValid()) {
            this.setMessage(messageData.getMessage());
            this.setErrorMessage(null);
        } else {
            this.setMessage(null);
            this.setErrorMessage(messageData.getMessage());
        }
        return messageData.isValid();
    }

    protected abstract MessageData isValidImpl(ILaunchConfiguration var1) throws CoreException;

    protected abstract TabFieldList<? super ELEMENTS, ? super PARAMS> getTabFields();

    protected static Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected static Composite createInnerComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(numColumns, false));
        GridData gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        return composite;
    }

    protected static GridLayout createHtmlStyleGridLayout(int numberOfColumns) {
        GridLayout layout = new GridLayout(numberOfColumns, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        return layout;
    }

    private static void storeEditor(FieldEditor editor, String errorValue) {
        if (editor.isValid()) {
            editor.store();
        } else {
            editor.getPreferenceStore().setValue(editor.getPreferenceName(), errorValue);
        }
    }

    static void addRadioButtonSwitcher(final Collection<Button> buttons) {
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.widget instanceof Button) {
                    Button button = (Button)e.widget;
                    if (!button.getSelection()) {
                        return;
                    }
                    for (Button other : buttons) {
                        if (other == button) continue;
                        other.setSelection(false);
                    }
                }
            }
        };
        for (Button button : buttons) {
            if ((button.getStyle() & 0x400000) == 0) {
                throw new IllegalArgumentException();
            }
            button.addSelectionListener(selectionListener);
        }
    }

    static <E, P> TabFieldList<E, P> createFieldListImpl(final List<? extends TabField<?, ?, ? super E, P>> tabFields) {
        return new TabFieldList<E, P>(){

            @Override
            public void setDefaults(ILaunchConfigurationWorkingCopy configuration, P params) {
                for (TabField field : tabFields) {
                    field.setDefault(configuration, params);
                }
            }

            @Override
            public void initializeFrom(E elements, ILaunchConfiguration configuration) {
                for (TabField field : tabFields) {
                    field.initializeFrom(elements, configuration);
                }
            }

            @Override
            public void saveToConfig(E elements, ILaunchConfigurationWorkingCopy configuration) {
                for (TabField field : tabFields) {
                    field.saveToConfig(elements, configuration);
                }
            }
        };
    }

    static <E, INNER, P> TabFieldList<E, P> createFieldListAdapting(final TabFieldList<? super INNER, ? super P> list, final Adapter<E, INNER> elementsAdapter) {
        return new TabFieldList<E, P>(){

            @Override
            public void setDefaults(ILaunchConfigurationWorkingCopy configuration, P params) {
                list.setDefaults(configuration, params);
            }

            @Override
            public void initializeFrom(E elements, ILaunchConfiguration configuration) {
                list.initializeFrom(elementsAdapter.get(elements), configuration);
            }

            @Override
            public void saveToConfig(E elements, ILaunchConfigurationWorkingCopy configuration) {
                list.saveToConfig(elementsAdapter.get(elements), configuration);
            }
        };
    }

    static <E, P> TabFieldList<E, P> createCompositeFieldList(final List<? extends TabFieldList<? super E, ? super P>> listList) {
        return new TabFieldList<E, P>(){

            @Override
            public void setDefaults(ILaunchConfigurationWorkingCopy configuration, P params) {
                for (TabFieldList list : listList) {
                    list.setDefaults(configuration, params);
                }
            }

            @Override
            public void initializeFrom(E elements, ILaunchConfiguration configuration) {
                for (TabFieldList list : listList) {
                    list.initializeFrom(elements, configuration);
                }
            }

            @Override
            public void saveToConfig(E elements, ILaunchConfigurationWorkingCopy configuration) {
                for (TabFieldList list : listList) {
                    list.saveToConfig(elements, configuration);
                }
            }
        };
    }

    static interface Adapter<F, T> {
        public T get(F var1);
    }

    static abstract class DefaultsProvider<T, C> {
        DefaultsProvider() {
        }

        abstract T getFallbackValue();

        abstract T getInitialConfigValue(C var1);
    }

    static abstract class FieldAccess<T, E> {
        FieldAccess() {
        }

        abstract void setValue(T var1, E var2);

        abstract T getValue(E var1);
    }

    static abstract class FieldEditorAccess<T, E>
    extends FieldAccess<T, E> {
        private final TypedMethods<T> fieldType;

        FieldEditorAccess(TypedMethods<T> fieldType) {
            this.fieldType = fieldType;
        }

        @Override
        void setValue(T value, E tabElements) {
            FieldEditor fieldEditor = this.getFieldEditor(tabElements);
            this.fieldType.setStoreDefaultValue(fieldEditor.getPreferenceStore(), fieldEditor.getPreferenceName(), value);
            fieldEditor.loadDefault();
        }

        @Override
        T getValue(E tabElements) {
            FieldEditor fieldEditor = this.getFieldEditor(tabElements);
            TabBase.storeEditor(fieldEditor, this.getEditorErrorValue());
            return this.fieldType.getStoreValue(fieldEditor.getPreferenceStore(), fieldEditor.getPreferenceName());
        }

        abstract FieldEditor getFieldEditor(E var1);

        abstract String getEditorErrorValue();
    }

    protected static class MessageData {
        public static final MessageData EMPTY_OK = new MessageData(true, null);
        private final boolean valid;
        private final String message;

        public MessageData(boolean isValid, String message) {
            this.valid = isValid;
            this.message = message;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getMessage() {
            return this.message;
        }
    }

    static class RadioButtonsLogic<K> {
        private final Map<K, Button> buttons;

        RadioButtonsLogic(Map<K, Button> buttons, final Listener listener) {
            this.buttons = buttons;
            SelectionListener selectionListener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    Button button;
                    if (listener != null && e.widget instanceof Button && (button = (Button)e.widget).getSelection()) {
                        listener.selectionChanged();
                    }
                }
            };
            for (Button button : buttons.values()) {
                button.addSelectionListener(selectionListener);
            }
        }

        void select(K key) {
            for (Map.Entry<K, Button> en : this.buttons.entrySet()) {
                en.getValue().setSelection(en.getKey().equals(key));
            }
        }

        K getSelected() {
            for (Map.Entry<K, Button> en : this.buttons.entrySet()) {
                if (!en.getValue().getSelection()) continue;
                return en.getKey();
            }
            return null;
        }

        static interface Listener {
            public void selectionChanged();
        }
    }

    static class TabField<P, L, E, C> {
        private final String configAttributeName;
        private final TypedMethods<P> typedMethods;
        private final FieldAccess<L, E> fieldAccess;
        private final DefaultsProvider<L, C> defaultsProvider;
        private final LaunchParams.ValueConverter<P, L> valueConverter;

        TabField(String configAttributeName, TypedMethods<P> typedMethods, FieldAccess<L, E> fieldAccess, DefaultsProvider<L, C> defaultsProvider, LaunchParams.ValueConverter<P, L> valueConverter) {
            this.typedMethods = typedMethods;
            this.defaultsProvider = defaultsProvider;
            this.configAttributeName = configAttributeName;
            this.fieldAccess = fieldAccess;
            this.valueConverter = valueConverter;
        }

        void saveToConfig(E tabElements, ILaunchConfigurationWorkingCopy config) {
            L logicalValue = this.fieldAccess.getValue(tabElements);
            Object persistentValue = this.valueConverter.encode(logicalValue);
            this.typedMethods.setConfigAttribute(config, this.configAttributeName, persistentValue);
        }

        void initializeFrom(E tabElements, ILaunchConfiguration config) {
            Object value;
            L fallbackLogicalValue = this.defaultsProvider.getFallbackValue();
            Object fallbackPersistenValue = this.valueConverter.encode(fallbackLogicalValue);
            try {
                Object persistentValue = this.typedMethods.getConfigAttribute(config, this.configAttributeName, fallbackPersistenValue);
                value = this.valueConverter.decode(persistentValue);
            }
            catch (CoreException e) {
                ChromiumDebugPlugin.log((Throwable)new Exception("Unexpected storage problem", e));
                value = fallbackLogicalValue;
            }
            this.fieldAccess.setValue(value, tabElements);
        }

        public void setDefault(ILaunchConfigurationWorkingCopy config, C context) {
            L value = this.defaultsProvider.getInitialConfigValue(context);
            if (value != null) {
                Object persistentValue = this.valueConverter.encode(value);
                this.typedMethods.setConfigAttribute(config, this.configAttributeName, persistentValue);
            }
        }
    }

    static interface TabFieldList<E, P> {
        public void setDefaults(ILaunchConfigurationWorkingCopy var1, P var2);

        public void initializeFrom(E var1, ILaunchConfiguration var2);

        public void saveToConfig(E var1, ILaunchConfigurationWorkingCopy var2);
    }

    static abstract class TypedMethods<T> {
        static final TypedMethods<String> STRING = new TypedMethods<String>(){

            @Override
            String getConfigAttribute(ILaunchConfiguration config, String attributeName, String defaultValue) throws CoreException {
                return config.getAttribute(attributeName, defaultValue);
            }

            @Override
            public void setConfigAttribute(ILaunchConfigurationWorkingCopy config, String attributeName, String value) {
                config.setAttribute(attributeName, value);
            }

            @Override
            void setStoreDefaultValue(IPreferenceStore store, String propertyName, String value) {
                store.setDefault(propertyName, value);
            }

            @Override
            String getStoreValue(IPreferenceStore store, String preferenceName) {
                return store.getString(preferenceName);
            }
        };
        static final TypedMethods<Integer> INT = new TypedMethods<Integer>(){

            @Override
            public void setConfigAttribute(ILaunchConfigurationWorkingCopy config, String attributeName, Integer value) {
                config.setAttribute(attributeName, (Object)value);
            }

            @Override
            Integer getConfigAttribute(ILaunchConfiguration config, String attributeName, Integer defaultValue) throws CoreException {
                return config.getAttribute(attributeName, defaultValue.intValue());
            }

            @Override
            void setStoreDefaultValue(IPreferenceStore store, String propertyName, Integer value) {
                store.setDefault(propertyName, value.intValue());
            }

            @Override
            Integer getStoreValue(IPreferenceStore store, String preferenceName) {
                return store.getInt(preferenceName);
            }
        };
        static final TypedMethods<Boolean> BOOL = new TypedMethods<Boolean>(){

            @Override
            public void setConfigAttribute(ILaunchConfigurationWorkingCopy config, String attributeName, Boolean value) {
                config.setAttribute(attributeName, (Object)value);
            }

            @Override
            Boolean getConfigAttribute(ILaunchConfiguration config, String attributeName, Boolean defaultValue) throws CoreException {
                return config.getAttribute(attributeName, defaultValue.booleanValue());
            }

            @Override
            void setStoreDefaultValue(IPreferenceStore store, String propertyName, Boolean value) {
                store.setDefault(propertyName, value.booleanValue());
            }

            @Override
            Boolean getStoreValue(IPreferenceStore store, String preferenceName) {
                return store.getBoolean(preferenceName);
            }
        };

        TypedMethods() {
        }

        abstract T getConfigAttribute(ILaunchConfiguration var1, String var2, T var3) throws CoreException;

        abstract void setConfigAttribute(ILaunchConfigurationWorkingCopy var1, String var2, T var3);

        abstract T getStoreValue(IPreferenceStore var1, String var2);

        abstract void setStoreDefaultValue(IPreferenceStore var1, String var2, T var3);
    }
}

