/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import java.util.List;
import org.cloudfoundry.client.lib.StartingInfo;
import org.cloudfoundry.client.lib.domain.ApplicationStats;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.InstanceState;
import org.cloudfoundry.client.lib.domain.InstanceStats;
import org.cloudfoundry.client.lib.domain.InstancesInfo;
import org.eclipse.cft.server.core.AbstractApplicationDelegate;
import org.eclipse.cft.server.core.ApplicationDeploymentInfo;
import org.eclipse.cft.server.core.ICloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudUtil;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.StringUtils;
import org.eclipse.cft.server.core.internal.application.ApplicationRegistry;
import org.eclipse.cft.server.core.internal.application.ApplicationRunState;
import org.eclipse.cft.server.core.internal.client.DeploymentInfoWorkingCopy;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.ExternalModule;

public class CloudFoundryApplicationModule
extends ExternalModule
implements ICloudFoundryApplicationModule {
    public static String APPLICATION_STATE_DEPLOYABLE = Messages.CloudFoundryApplicationModule_STATE_DEPLOYABLE;
    public static String APPLICATION_STATE_DEPLOYED = Messages.CloudFoundryApplicationModule_STATE_DEPLOYED;
    public static String APPLICATION_STATE_UPLOADING = Messages.CloudFoundryApplicationModule_STATE_UPLOADING;
    public static String DEPLOYMENT_STATE_LAUNCHED = Messages.CloudFoundryApplicationModule_STATE_LAUNCHED;
    public static String DEPLOYMENT_STATE_LAUNCHING = Messages.CloudFoundryApplicationModule_STATE_LAUNCHING;
    public static String DEPLOYMENT_STATE_STARTING_SERVICES = Messages.CloudFoundryApplicationModule_STATE_STARTING_SERVICES;
    public static String DEPLOYMENT_STATE_STOPPED = Messages.CloudFoundryApplicationModule_STATE_STOPPED;
    public static String DEPLOYMENT_STATE_STOPPING = Messages.CloudFoundryApplicationModule_STATE_STOPPING;
    public static String DEPLOYMENT_STATE_WAITING_TO_LAUNCH = Messages.CloudFoundryApplicationModule_STATE_WAITING_TO_LAUNCH;
    private static final String MODULE_ID = "org.eclipse.cft.server.core.CloudFoundryApplicationModule";
    private static final String MODULE_VERSION = "1.0";
    private CloudApplication application;
    private String deployedAppName;
    private ApplicationStats applicationStats;
    private InstancesInfo instancesInfo;
    private ApplicationDeploymentInfo deploymentInfo;
    private StartingInfo startingInfo;
    private static final String CFAM_MODULE_ID = "org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule";
    private String localModuleId;
    private final IServer server;
    private IStatus validationStatus;

    public CloudFoundryApplicationModule(IModule module, String deployedApplicationName, IServer server) {
        this(module, deployedApplicationName, module.getName(), server);
    }

    public CloudFoundryApplicationModule(String deployedApplicationName, IServer server) {
        this(null, deployedApplicationName, deployedApplicationName, server);
    }

    protected CloudFoundryApplicationModule(IModule module, String deployedApplicationName, String localName, IServer server) {
        super(localName, localName, MODULE_ID, MODULE_VERSION, null);
        Assert.isNotNull((Object)deployedApplicationName);
        Assert.isNotNull((Object)localName);
        Assert.isNotNull((Object)server);
        this.localModuleId = module != null ? module.getId() : CFAM_MODULE_ID;
        this.server = server;
        this.setDeployedApplicationName(deployedApplicationName);
        CloudFoundryPlugin.trace("Created ApplicationModule " + deployedApplicationName + " for module " + module);
    }

    public CloudApplication getApplication() {
        return this.application;
    }

    public synchronized String getDeployedApplicationName() {
        return this.deployedAppName;
    }

    public ApplicationStats getApplicationStats() {
        return this.applicationStats;
    }

    public StartingInfo getStartingInfo() {
        return this.startingInfo;
    }

    public void setStartingInfo(StartingInfo startingInfo) {
        this.startingInfo = startingInfo;
    }

    public InstancesInfo getInstancesInfo() {
        return this.instancesInfo;
    }

    public synchronized int getInstanceCount() {
        if (this.application != null) {
            return this.application.getInstances();
        }
        return 0;
    }

    public synchronized ApplicationDeploymentInfo getDeploymentInfo() {
        return this.deploymentInfo != null ? this.deploymentInfo.copy() : null;
    }

    public synchronized DeploymentInfoWorkingCopy resolveDeploymentInfoWorkingCopy(IProgressMonitor monitor) throws CoreException {
        ModuleDeploymentInfoWorkingCopy wc = new ModuleDeploymentInfoWorkingCopy(this);
        wc.fill(monitor);
        return wc;
    }

    public synchronized void validateAndUpdateStatus() throws CoreException {
        IStatus status = this.validate();
        this.setStatus(status);
        if (status.getSeverity() == 4) {
            throw new CoreException(status);
        }
    }

    public synchronized IStatus validate() {
        IStatus status = Status.OK_STATUS;
        if (this.deploymentInfo == null) {
            String message = NLS.bind((String)Messages.CloudFoundryApplicationModule_SERVER_OUT_OF_SYNC, (Object)this.server.getId());
            status = CloudFoundryPlugin.getErrorStatus(message);
        } else {
            AbstractApplicationDelegate delegate = ApplicationRegistry.getApplicationDelegate(this.getLocalModule());
            IStatus iStatus = status = delegate != null ? delegate.validateDeploymentInfo(this.deploymentInfo) : CloudUtil.basicValidateDeploymentInfo(this.deploymentInfo);
            if (status == null) {
                status = Status.OK_STATUS;
            }
            if (!status.isOK()) {
                status = CloudFoundryPlugin.getErrorStatus(NLS.bind((String)Messages.ERROR_APP_DEPLOYMENT_VALIDATION_ERROR, (Object)this.getDeployedApplicationName(), (Object)status.getMessage()));
            }
        }
        return status;
    }

    @Override
    public IModule getLocalModule() {
        if (this.localModuleId == null) {
            return null;
        }
        if (this.localModuleId == CFAM_MODULE_ID) {
            return this;
        }
        IModule newModule = null;
        IModule[] lm = this.server.getModules();
        if (lm != null) {
            IModule[] iModuleArray = lm;
            int n = lm.length;
            int n2 = 0;
            while (n2 < n) {
                IModule im = iModuleArray[n2];
                if (im.getId().equals(this.localModuleId)) {
                    newModule = im;
                    break;
                }
                ++n2;
            }
        }
        if (newModule == null) {
            return this;
        }
        return newModule;
    }

    public int getPublishState() {
        return 1;
    }

    public String getServerTypeId() {
        return this.server.getServerType().getId();
    }

    public synchronized int getState() {
        return CloudFoundryApplicationModule.getCloudState(this.getApplication(), this.applicationStats);
    }

    public synchronized ApplicationRunState getRunState() {
        int startingState;
        if (this.getLocalModule() != null && (startingState = this.getStateInServer()) == 1) {
            return ApplicationRunState.getRunState(startingState);
        }
        return ApplicationRunState.getRunState(CloudFoundryApplicationModule.getCloudState(this.getApplication(), this.applicationStats));
    }

    public int getStateInServer() {
        return this.server.getModuleState(new IModule[]{this.getLocalModule()});
    }

    public static int getCloudState(CloudApplication cloudApp, ApplicationStats applicationStats) {
        List records;
        if (applicationStats != null && (records = applicationStats.getRecords()) != null) {
            for (InstanceStats stats : records) {
                if (stats == null || stats.getState() != InstanceState.RUNNING) continue;
                return 2;
            }
        }
        if (cloudApp != null && cloudApp.getState() == CloudApplication.AppState.STOPPED) {
            return 4;
        }
        return 0;
    }

    public boolean isExternal() {
        return this.localModuleId == CFAM_MODULE_ID;
    }

    public synchronized void setStatus(IStatus status) {
        this.validationStatus = status == null || status.isOK() ? null : status;
    }

    public synchronized void setAndLogErrorStatus(Throwable e, String label) {
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        }
        if (status == null && e != null) {
            String message = e.getMessage();
            if (StringUtils.isEmpty(message)) {
                message = NLS.bind((String)Messages.CloudFoundryApplicationModule_MODULE_ERROR, (Object)label, (Object)e.getClass().getSimpleName());
            }
            status = CloudFoundryPlugin.getErrorStatus(message);
        }
        this.setStatus(status);
        if (status != null) {
            if (status.getSeverity() == 4) {
                CloudFoundryPlugin.logError(status.getMessage());
            } else {
                CloudFoundryPlugin.logInfo(status.getMessage());
            }
        }
    }

    public synchronized IStatus getStatus() {
        return this.validationStatus;
    }

    public synchronized void setApplicationStats(ApplicationStats applicationStats) {
        this.applicationStats = applicationStats;
    }

    public synchronized void setInstancesInfo(InstancesInfo instancesInfo) {
        this.instancesInfo = instancesInfo;
    }

    public synchronized void setCloudApplication(CloudApplication cloudApplication) {
        ApplicationDeploymentInfo cloudApplicationInfo;
        this.application = cloudApplication;
        if (this.application != null && (cloudApplicationInfo = this.resolveDeployedApplicationInformation()) != null) {
            this.internalSetDeploymentInfo(cloudApplicationInfo);
        }
    }

    public synchronized boolean isDeployed() {
        return this.exists() && this.getState() != 0;
    }

    public synchronized boolean exists() {
        return this.getApplication() != null;
    }

    private void internalSetDeploymentInfo(ApplicationDeploymentInfo deploymentInfo) {
        this.deploymentInfo = deploymentInfo;
        if (deploymentInfo != null && deploymentInfo.getDeploymentName() != null) {
            this.setDeployedApplicationName(deploymentInfo.getDeploymentName());
        }
    }

    protected ApplicationDeploymentInfo resolveDeployedApplicationInformation() {
        if (this.application == null) {
            return null;
        }
        AbstractApplicationDelegate delegate = ApplicationRegistry.getApplicationDelegate(this.getLocalModule());
        ApplicationDeploymentInfo info = null;
        CloudFoundryServer cloudServer = this.getCloudFoundryServer();
        if (delegate != null) {
            try {
                info = delegate.getExistingApplicationDeploymentInfo(this, cloudServer.getServer());
            }
            catch (CoreException e) {
                CloudFoundryPlugin.logError(e);
            }
        }
        if (info == null) {
            info = CloudUtil.parseApplicationDeploymentInfo(this.application);
        }
        return info;
    }

    protected void setDeployedApplicationName(String applicationName) {
        Assert.isNotNull((Object)applicationName);
        if (!applicationName.equals(this.deployedAppName)) {
            this.deployedAppName = applicationName;
            if (this.localModuleId != null) {
                CloudFoundryServer cloudServer = this.getCloudFoundryServer();
                cloudServer.updateApplicationModule(this);
            }
        }
    }

    protected ApplicationDeploymentInfo getDefaultDeploymentInfo(IProgressMonitor monitor) throws CoreException {
        AbstractApplicationDelegate delegate = ApplicationRegistry.getApplicationDelegate(this.getLocalModule(), this.getCloudFoundryServer());
        ApplicationDeploymentInfo defaultInfo = null;
        if (delegate != null) {
            try {
                defaultInfo = delegate.getDefaultApplicationDeploymentInfo(this, this.getCloudFoundryServer().getServer(), monitor);
            }
            catch (CoreException e) {
                CloudFoundryPlugin.logError(e);
            }
        }
        if (defaultInfo == null) {
            defaultInfo = this.createGeneralDefaultInfo();
        }
        return defaultInfo;
    }

    protected ApplicationDeploymentInfo createGeneralDefaultInfo() {
        ApplicationDeploymentInfo info = new ApplicationDeploymentInfo(this.getDeployedApplicationName());
        info.setMemory(512);
        return info;
    }

    protected CloudFoundryServer getCloudFoundryServer() {
        return (CloudFoundryServer)((Object)this.server.loadAdapter(CloudFoundryServer.class, null));
    }

    protected class ModuleDeploymentInfoWorkingCopy
    extends DeploymentInfoWorkingCopy {
        protected ModuleDeploymentInfoWorkingCopy(CloudFoundryApplicationModule appModule) {
            super(appModule);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void save() {
            CloudFoundryApplicationModule cloudFoundryApplicationModule = this.appModule;
            synchronized (cloudFoundryApplicationModule) {
                ApplicationDeploymentInfo info = new ApplicationDeploymentInfo(CloudFoundryApplicationModule.this.getDeployedApplicationName());
                info.setInfo(this);
                this.appModule.internalSetDeploymentInfo(info);
            }
        }
    }
}

