/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.codegen.jet.JETAttributeItem;
import org.eclipse.emf.codegen.jet.JETCommentItem;
import org.eclipse.emf.codegen.jet.JETCompilationUnit;
import org.eclipse.emf.codegen.jet.JETDirectiveItem;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.jet.JETGenerator;
import org.eclipse.emf.codegen.jet.JETItem;
import org.eclipse.emf.codegen.jet.JETJavaGenerator;
import org.eclipse.emf.codegen.jet.JETJavaItem;
import org.eclipse.emf.codegen.jet.JETMark;
import org.eclipse.emf.codegen.jet.JETSubItem;
import org.eclipse.emf.codegen.jet.JETTokenItem;
import org.eclipse.emf.codegen.jet.JETValueElementItem;
import org.eclipse.emf.codegen.jet.JETValueItem;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMImport;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JETSkeleton {
    private static final Pattern BUILDER_NAME_PATTERN = Pattern.compile("[^\n\r]*\\b+(\\p{Alpha}\\p{Alnum}*)+[ \t]*=[^\n\r]+");
    protected final String NL;
    protected final String SKELETON_COMPILATION_UNIT;
    protected final String STATIC_NL_DECLARATION;
    protected final String CREATE_METHOD_DECLARATION_HEAD;
    protected final String CREATE_METHOD_DECLARATION_MIDDLE;
    protected final String CREATE_METHOD_DECLARATION_MIDDLE2;
    protected final String CREATE_METHOD_DECLARATION_TAIL;
    protected final String NL_DECLARATION;
    protected final String NL_DECLARATION_TAIL;
    protected final String STRING_BUFFER_DECLARATION;
    protected final String STRING_BUFFER_RETURN;
    protected DOMFactory jdomFactory = new DOMFactory();
    protected IDOMCompilationUnit compilationUnit;
    protected String nlString;
    protected String builder;
    protected String builderName;
    protected static final Pattern NL_PATTERN = Pattern.compile("([\\n][\\r]?|[\\r][\\n]?)", 8);

    public JETSkeleton() {
        this(System.getProperties().getProperty("line.separator"), null);
    }

    public JETSkeleton(String lineSeparator, String builder) {
        String string = this.NL = lineSeparator == null ? "System.getProperties().getProperty(\"line.separator\")" : lineSeparator;
        this.builder = builder == null ? "StringBuffer stringBuffer = new StringBuffer();" : (builder.contains(";") ? builder.trim() : String.valueOf(builder.trim()) + ";");
        this.builderName = JETSkeleton.getBuilderName(this.builder);
        if (this.builderName == null) {
            this.builder = "StringBuffer stringBuffer = new StringBuffer();";
            this.builderName = "stringBuffer";
        }
        this.SKELETON_COMPILATION_UNIT = "public class CLASS" + this.NL + "{" + this.NL + "  public String generate(Object argument)" + this.NL + "  {" + this.NL + "    return \"\";" + this.NL + "  }" + this.NL + "}" + this.NL;
        this.STATIC_NL_DECLARATION = "  protected static String nl;" + this.NL;
        this.CREATE_METHOD_DECLARATION_HEAD = "  public static synchronized ";
        this.CREATE_METHOD_DECLARATION_MIDDLE = " create(String lineSeparator)" + this.NL + "  {" + this.NL + "    nl = lineSeparator;" + this.NL + "    ";
        this.CREATE_METHOD_DECLARATION_MIDDLE2 = " result = new ";
        this.CREATE_METHOD_DECLARATION_TAIL = "();" + this.NL + "    nl = null;" + this.NL + "    return result;" + this.NL + "  }" + this.NL + this.NL;
        this.NL_DECLARATION = "  public final String NL = nl == null ? (";
        this.NL_DECLARATION_TAIL = ") : nl;" + this.NL;
        this.STRING_BUFFER_DECLARATION = "    final " + this.builder + this.NL;
        this.STRING_BUFFER_RETURN = "    return " + this.builderName + ".toString();" + this.NL;
        this.compilationUnit = this.jdomFactory.createCompilationUnit(this.SKELETON_COMPILATION_UNIT, "CLASS");
        this.nlString = "System.getProperties().getProperty(\"line.separator\")";
    }

    public static String getBuilderName(String builder) {
        if (builder == null) {
            return null;
        }
        Matcher matcher = BUILDER_NAME_PATTERN.matcher(builder);
        return matcher.matches() ? matcher.group(1) : null;
    }

    public String getBuilder() {
        return this.builder;
    }

    public String getBuilderName() {
        return this.builderName;
    }

    public String getCompilationUnitContents() {
        return this.compilationUnit.getContents();
    }

    public IDOMCompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public void setCompilationUnitContents(String contents) {
        this.compilationUnit = this.jdomFactory.createCompilationUnit(this.convertLineFeed(contents), "CLASS");
    }

    public boolean isWellFormed() {
        return this.getClassName() != null && this.getLastMethod() != null;
    }

    public String getNLString() {
        return this.nlString;
    }

    public void setNLString(String nlString) {
        this.nlString = nlString;
    }

    public String getPackageName() {
        IDOMNode node = this.compilationUnit.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 2) {
                return node.getName();
            }
            node = node.getNextNode();
        }
        return "";
    }

    public void setPackageName(String packageName) {
        IDOMNode node = this.compilationUnit.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 2) {
                node.setName(packageName);
                return;
            }
            node = node.getNextNode();
        }
        this.compilationUnit.getFirstChild().insertSibling((IDOMNode)this.jdomFactory.createPackage("package " + packageName + ";" + this.NL + this.NL));
    }

    public void setConstants(List<String> constants) {
        IDOMNode node = this.compilationUnit.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 4) {
                String name = node.getName();
                IDOMNode insertionNode = node.getFirstChild();
                insertionNode.insertSibling((IDOMNode)this.jdomFactory.createField(this.STATIC_NL_DECLARATION));
                insertionNode.insertSibling((IDOMNode)this.jdomFactory.createMethod(String.valueOf(this.CREATE_METHOD_DECLARATION_HEAD) + name + this.CREATE_METHOD_DECLARATION_MIDDLE + name + this.CREATE_METHOD_DECLARATION_MIDDLE2 + name + this.CREATE_METHOD_DECLARATION_TAIL));
                insertionNode.insertSibling((IDOMNode)this.jdomFactory.createField(String.valueOf(this.NL_DECLARATION) + this.getNLString() + this.NL_DECLARATION_TAIL));
                Iterator<String> i = constants.iterator();
                while (i.hasNext()) {
                    String constant = "  " + i.next() + this.NL;
                    if (!i.hasNext()) {
                        constant = String.valueOf(constant) + this.NL;
                    }
                    insertionNode.insertSibling((IDOMNode)this.jdomFactory.createField(constant));
                }
                break;
            }
            node = node.getNextNode();
        }
    }

    public void setBody(List<String> lines) {
        IDOMMethod method = this.getLastMethod();
        if (method != null) {
            StringBuilder body = new StringBuilder();
            body.append(String.valueOf(this.NL) + "  {" + this.NL);
            body.append(this.STRING_BUFFER_DECLARATION);
            for (String line : lines) {
                body.append("    ");
                body.append(this.convertLineFeed(line));
                body.append(this.NL);
            }
            body.append(this.STRING_BUFFER_RETURN);
            body.append("  }" + this.NL);
            method.setBody(body.toString());
        }
    }

    public String convertLineFeed(String value) {
        String nl;
        Matcher matcher = NL_PATTERN.matcher(value);
        if (matcher.find() && !this.NL.equals(nl = matcher.group(1))) {
            return value.replaceAll(nl, this.NL);
        }
        return value;
    }

    public String getMethodName() {
        IDOMMethod method = this.getLastMethod();
        if (method != null) {
            return method.getName();
        }
        return "";
    }

    public void addImports(String importList) {
        IDOMNode node = this.compilationUnit.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 4) {
                StringTokenizer stringTokenizer = new StringTokenizer(importList, " \t\n\r");
                while (stringTokenizer.hasMoreTokens()) {
                    IDOMImport imports;
                    String token = stringTokenizer.nextToken();
                    String newImport = "import " + token + ";" + this.NL;
                    if (!stringTokenizer.hasMoreTokens()) {
                        newImport = String.valueOf(newImport) + this.NL;
                    }
                    if ((imports = this.jdomFactory.createImport(newImport)) == null) continue;
                    node.insertSibling((IDOMNode)imports);
                }
                return;
            }
            node = node.getNextNode();
        }
    }

    public String getQualifiedClassName() {
        String packageName = this.getPackageName();
        String className = this.getClassName();
        return packageName.length() == 0 ? className : String.valueOf(packageName) + '.' + className;
    }

    public String getClassName() {
        IDOMNode node = this.compilationUnit.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 4) {
                return node.getName();
            }
            node = node.getNextNode();
        }
        return null;
    }

    public void setClassName(String className) {
        IDOMNode node = this.compilationUnit.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 4) {
                node.setName(className);
            }
            node = node.getNextNode();
        }
    }

    public void setHeader(String header) {
        StringBuilder headerContent = new StringBuilder();
        headerContent.append("/*");
        headerContent.append(this.NL);
        String[] stringArray = header.split("\r?\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            headerContent.append(" * ");
            headerContent.append(line);
            headerContent.append(this.NL);
            ++n2;
        }
        headerContent.append(" */");
        headerContent.append(this.NL);
        this.compilationUnit.setHeader(headerContent.toString());
    }

    protected IDOMMethod getLastMethod() {
        IDOMMethod method = null;
        IDOMNode node = this.compilationUnit.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 4) {
                IDOMNode child = node.getFirstChild();
                while (child != null) {
                    if (child.getNodeType() == 6) {
                        method = (IDOMMethod)child;
                    }
                    child = child.getNextNode();
                }
            }
            node = node.getNextNode();
        }
        return method;
    }

    public JETCompilationUnit getCompilerResult(List<String> templateURIs, List<JETGenerator> generators, List<JETItem> jetItems, List<JETException> problems) {
        JETAttributeItem builderAttribute;
        JETAttributeItem nlStringAttribute;
        JETValueItem valueItem;
        JETTokenItem valueToken;
        JETDirectiveItem jetJETDirectiveItem;
        String compilationUnit = this.getCompilationUnitContents();
        String packageName = this.getPackageName();
        String className = this.getClassName();
        String qualifiedName = packageName.length() == 0 ? className : String.valueOf(packageName) + "." + className;
        JETCompilationUnit result = new JETCompilationUnit(templateURIs, qualifiedName, compilationUnit, jetItems, problems);
        JETItem jetItem = jetItems.get(0);
        if (jetItem instanceof JETCommentItem) {
            JETCommentItem jetCommentItem = (JETCommentItem)jetItem;
            List<JETSubItem> lineItems = jetCommentItem.getLineItems();
            int offset = 0;
            for (JETSubItem lineItem : lineItems) {
                Matcher matcher = Pattern.compile(" * (" + Pattern.quote(lineItem.getText()) + ")").matcher(compilationUnit);
                if (!matcher.find(offset)) continue;
                offset = matcher.end() + 1;
                int start = matcher.start(1);
                int end = matcher.end(1);
                result.addRange(lineItem.getStart(), lineItem.getStop(), start, end - start, lineItem);
            }
        }
        if ((jetJETDirectiveItem = result.getJETJETDirectiveItem()) != null) {
            JETTokenItem valueToken2;
            JETValueItem valueItem2;
            Matcher matcher;
            JETAttributeItem classAttribute;
            JETAttributeItem importsAttribute;
            JETTokenItem valueToken3;
            JETValueItem valueItem3;
            Matcher matcher2;
            JETAttributeItem packageAttribute = jetJETDirectiveItem.getAttribute("package");
            if (packageAttribute != null && (matcher2 = Pattern.compile("package (" + Pattern.quote((valueItem3 = (valueToken3 = packageAttribute.getValueToken()).getValueItem()).getValue()) + ");").matcher(compilationUnit)).find()) {
                int start = matcher2.start(1);
                int end = matcher2.end(1);
                result.addRange(valueItem3.getStart(), valueItem3.getStop(), start, end - start, valueItem3);
            }
            if ((importsAttribute = jetJETDirectiveItem.getAttribute("imports")) != null) {
                valueToken = importsAttribute.getValueToken();
                valueItem = valueToken.getValueItem();
                List<JETValueElementItem> elements = valueItem.getElements();
                for (JETValueElementItem jetValueElementItem : elements) {
                    Matcher matcher3 = Pattern.compile("import (" + Pattern.quote(jetValueElementItem.getValue()) + ");").matcher(compilationUnit);
                    if (!matcher3.find()) continue;
                    int start = matcher3.start(1);
                    int end = matcher3.end(1);
                    result.addRange(jetValueElementItem.getStart(), jetValueElementItem.getStop(), start, end - start, valueItem);
                }
            }
            if ((classAttribute = jetJETDirectiveItem.getAttribute("class")) != null && (matcher = Pattern.compile("^[ \t]*(?:public|private|protected)?[ \t]*class (" + Pattern.quote((valueItem2 = (valueToken2 = classAttribute.getValueToken()).getValueItem()).getValue()) + ")[ \t{]*$", 8).matcher(compilationUnit)).find()) {
                int start = matcher.start(1);
                int end = matcher.end(1);
                result.addRange(valueItem2.getStart(), valueItem2.getStop(), start, end - start, valueItem2);
            }
        }
        int nlDeclarationstart = compilationUnit.indexOf(this.NL_DECLARATION);
        if (jetJETDirectiveItem != null && (nlStringAttribute = jetJETDirectiveItem.getAttribute("nlString")) != null) {
            valueToken = nlStringAttribute.getValueToken();
            valueItem = valueToken.getValueItem();
            result.addRange(valueItem.getStart(), valueItem.getStop(), nlDeclarationstart + this.NL_DECLARATION.length(), valueItem.getText().length(), valueItem);
        }
        int builderStart = compilationUnit.indexOf(this.STRING_BUFFER_DECLARATION, nlDeclarationstart);
        int offset = builderStart + this.STRING_BUFFER_DECLARATION.length();
        if (jetJETDirectiveItem != null && (builderAttribute = jetJETDirectiveItem.getAttribute("builder")) != null) {
            JETTokenItem valueToken4 = builderAttribute.getValueToken();
            JETValueItem valueItem4 = valueToken4.getValueItem();
            result.addRange(valueItem4.getStart(), valueItem4.getStop(), builderStart + "    final ".length(), valueItem4.getText().length(), valueItem4);
        }
        for (JETGenerator generator : generators) {
            offset += 4;
            if (generator instanceof JETJavaGenerator) {
                JETJavaGenerator javaGenerator = (JETJavaGenerator)generator;
                JETMark start = javaGenerator.getStart();
                JETMark stop = javaGenerator.getStop();
                int relativeJavaOffset = javaGenerator.getRelativeJavaOffset();
                int javaLength = javaGenerator.getJavaLength();
                JETJavaItem javaItem = javaGenerator.getJavaItem();
                result.addRange(start, stop, offset += relativeJavaOffset, javaLength, javaItem);
                if (javaItem != null) {
                    javaItem.setJavaOffset(offset);
                    javaItem.setJavaLength(javaLength);
                }
                offset += javaLength;
            }
            offset = compilationUnit.indexOf(10, offset) + 1;
        }
        return result;
    }
}

